% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batsmanRunsVenue.R
\name{batsmanRunsVenue}
\alias{batsmanRunsVenue}
\title{Batsman runs at different venues}
\usage{
batsmanRunsVenue(df, name= "A Leg Glance",dateRange,staticIntv=1)
}
\arguments{
\item{df}{Data frame}

\item{name}{Name of batsman}

\item{dateRange}{Date interval to consider}

\item{staticIntv}{Static or interactive -staticIntv =1 (static plot) &  staticIntv =2 (interactive  plot)}
}
\value{
None
}
\description{
This function computes and plots the mean runs scored by the batsman at different
venues of the world
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
#Get the data frame for Kohli
kohli <- getBatsmanDetails(team="India",name="Kohli",dir=pathToFile)
batsmanRunsVenue(kohli,"Kohli",dateRange)
}

}
\references{
\url{https://cricsheet.org/}\cr
\url{https://gigadom.in/}\cr
\url{https://github.com/tvganesh/yorkrData/}
}
\seealso{
\code{\link{batsmanFoursSixes}}\cr
\code{\link{batsmanRunsVsDeliveries}}\cr
\code{\link{batsmanRunsVsStrikeRate}}\cr
\code{\link{batsmanRunsPredict}}\cr
\code{\link{teamBatsmenPartnershipAllOppnAllMatches}}\cr
\code{\link{batsmanRunsAgainstOpposition}}\cr
}
\author{
Tinniam V Ganesh
}
