% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teamBowlersWicketRunsOppnAllMatches.R
\name{teamBowlersWicketRunsOppnAllMatches}
\alias{teamBowlersWicketRunsOppnAllMatches}
\title{Team bowlers wicket runs against an opposition in all matches}
\usage{
teamBowlersWicketRunsOppnAllMatches(matches,main,opposition,plot=TRUE)
}
\arguments{
\item{matches}{The data frame of all matches between a team the opposition. This dataframe can be obtained with
matches <- getAllMatchesBetweenTeams("Australia","India",dir="../data")}

\item{main}{The team for which the performance is required}

\item{opposition}{The opposing team}

\item{plot}{If plot=TRUE then a plot is displayed else a dataframe is returned}
}
\value{
None or dataframe
The return depends on the value of the plot
}
\description{
This function computes performance of bowlers of a team and the runs conceded against an
opposition in all matches against the opposition
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
# Get all matches between India and Australia
matches <- getAllMatchesBetweenTeams("Australia","India",dir="../data")

teamBowlersWicketRunsOppnAllMatches(matches,"India","Australia")
m <-teamBowlerWicketsRunsOppnAllMatches(matches,"Australia","India",plot=FALSE)
}

}
\references{
\url{https://cricsheet.org/}\cr
\url{https://gigadom.in/}\cr
\url{https://github.com/tvganesh/yorkrData/}
}
\seealso{
\code{\link{teamBatsmenPartnershipAllOppnAllMatches}}\cr
\code{\link{teamBowlersWicketsOppnAllMatches}}\cr
\code{\link{teamBatsmenPartnershipOppnAllMatchesChart}}\cr
\code{\link{teamBowlersVsBatsmenAllOppnAllMatchesRept}}\cr
\code{\link{teamBowlersVsBatsmenAllOppnAllMatchesPlot}}\cr
}
\author{
Tinniam V Ganesh
}
