% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cryptic_transcripts_methods.R
\name{genome_wide_scores}
\alias{genome_wide_scores}
\title{Genome-wide cryptic scores.}
\usage{
genome_wide_scores(coverageDataSet, method = c("ratio", "enrichment",
  "probabilistic"), outfile, introns = NULL, windowLength = 100,
  iterations = 10000)
}
\arguments{
\item{coverageDataSet}{A coverageDataSet containing the coverage values for all genes.}

\item{method}{A caracter vector indicating the method to be used.}

\item{outfile}{A character vector indicating the output file name.}

\item{introns}{An objet of type \code{\link{annotationsSet}}
containing the annotations of the intronic regions.
Note: The introns must have same name as the gene they
are associated with.}

\item{windowLength}{If the \code{method} is "ratio", specify the length of the window to use
at each end of the gene.}

\item{iterations}{If the \code{method} is "probabilistic", specify the number of iterations.}
}
\description{
Genome-wide calculation of cryptic scores with a specified method.
}
\examples{
data("rna_seq_signals")
#genome_wide_scores(rna_seq_signals, "ratio", "ratio.txt")
genome_wide_scores(rna_seq_signals, "enrichment", "enrichment.txt")
#genome_wide_scores(rna_seq_signals, "probabilistic", "probabilistic.txt")
unlink(c("ratio.txt", "enrichment.txt", "probabilistic.txt"))
}

