% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rstudio.R
\name{rstudio_type}
\alias{rstudio_type}
\title{Type a character vector into the RStudio source editor}
\usage{
rstudio_type(x, pause = function() 0.1, mistake = 0, save = 0)
}
\arguments{
\item{x}{A character vector.}

\item{pause}{A function to return a number in seconds to pause after typing
each character.}

\item{mistake}{The probability of making random mistakes when typing the next
character. A random mistake is a random string typed into the editor and
deleted immediately.}

\item{save}{The probability of saving the document after typing each
character. Note that If a document is not opened from a file, it will never
be saved.}
}
\description{
Use the \pkg{rstudioapi} package to insert characters one by one into the
RStudio source editor, as if they were typed by a human.
}
\examples{
library(xfun)
if (loadable("rstudioapi") && rstudioapi::isAvailable()) {
    rstudio_type("Hello, RStudio! xfun::rstudio_type() looks pretty cool!", 
        pause = function() runif(1, 0, 0.5), mistake = 0.1)
}
}
