% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cepstrum.R
\name{cepstrum}
\alias{cepstrum}
\title{cepstrum}
\usage{
cepstrum(
  listOfFiles = NULL,
  optLogFilePath = NULL,
  beginTime = 0,
  centerTime = FALSE,
  endTime = 0,
  resolution = 40,
  fftLength = 0,
  windowShift = 5,
  window = "BLACKMAN",
  toFile = TRUE,
  explicitExt = NULL,
  outputDirectory = NULL,
  forceToLog = useWrasspLogger,
  verbose = TRUE
)
}
\arguments{
\item{listOfFiles}{vector of file paths to be processed by function}

\item{optLogFilePath}{path to option log file}

\item{beginTime}{= <time>: set begin of analysis interval to <time> seconds
(default: begin of data)}

\item{centerTime}{= <time>: set single-frame analysis with the analysis
window centred at <time> seconds; overrules beginTime, endTime and
windowShift options}

\item{endTime}{= <time>: set end of analysis interval to <time> seconds
(default: end of data)}

\item{resolution}{= <freq>: set FFT length to the smallest value which
results in a frequency resolution of <freq> Hz or better (default: 40.0)}

\item{fftLength}{= <num>: set FFT length to <num> points (overrules default
and 'resolution' option)}

\item{windowShift}{= <dur>: set analysis window shift to <dur> ms
(default: 5.0)}

\item{window}{= <type>: set analysis window function to <type> (default:
BLACKMAN)}

\item{toFile}{write results to file (default extension depends on )}

\item{explicitExt}{set if you wish to override the default extension}

\item{outputDirectory}{directory in which output files are stored. Defaults to NULL, i.e.
the directory of the input files}

\item{forceToLog}{is set by the global package variable useWrasspLogger. This is set
to FALSE by default and should be set to TRUE is logging is desired.}

\item{verbose}{display infos & show progress bar}
}
\value{
nrOfProcessedFiles or if only one file to process return
AsspDataObj of that file
}
\description{
calculate cepstral coefficients using libassp
}
\details{
Short-term cepstral analysis of the signal in <listOfFiles>
using the Fast Fourier Transform. The number of
coefficients per output record will also equal the
FFT length / 2 + 1 (i.e. be non-mirrored).
Analysis results will be written to a file with the
base name of the input file and as extension '.cep'.
Default output is in SSFF format with
'cep' as track name.
}
\examples{
# get path to audio file
path2wav <- list.files(system.file("extdata", package = "wrassp"), 
                       pattern = glob2rx("*.wav"), 
                       full.names = TRUE)[1]

# calulate cepstrum
res <- cepstrum(path2wav, toFile=FALSE)

# plot cepstral values at midpoint of signal
plot(res$cep[dim(res$cep)[1]/2,], 
     type='l', 
     xlab='cepstral value index', 
     ylab='cepstral value')
     
}
\seealso{
\code{\link{dftSpectrum}}, \code{\link{cssSpectrum}}, \code{\link{lpsSpectrum}}; 
all derived from libassp's spectrum function
}
\author{
Raphael Winkelmann

Lasse Bombien
}
