% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmsana.R
\name{rmsana}
\alias{rmsana}
\title{rmsana}
\usage{
rmsana(listOfFiles = NULL, optLogFilePath = NULL, beginTime = 0,
  centerTime = FALSE, endTime = 0, windowShift = 5,
  windowSize = 20, effectiveLength = TRUE, linear = FALSE,
  window = "HAMMING", toFile = TRUE, explicitExt = NULL,
  outputDirectory = NULL, forceToLog = useWrasspLogger,
  verbose = TRUE)
}
\arguments{
\item{listOfFiles}{vector of file paths to be processed by function}

\item{optLogFilePath}{path to option log file}

\item{beginTime}{= <time>:  set begin of analysis interval to <time> seconds (default = 0: begin of file)}

\item{centerTime}{= <time>: set single-frame analysis with the analysis window centred at <time> seconds; 
overrules beginTime, endTime and windowShift options}

\item{endTime}{= <time>: set end of analysis interval to <time> seconds (default: end of file)}

\item{windowShift}{= <dur>: set analysis window shift to <dur> ms (default: 5.0)}

\item{windowSize}{= <dur>: set analysis window size to <dur> ms; overrules effectiveLength option}

\item{effectiveLength}{make window size effective rather than exact}

\item{linear}{calculate linear RMS values (default: values in dB)}

\item{window}{= <type>: set analysis window function to <type> (default: HAMMING)}

\item{toFile}{write results to file (default extension is .rms)}

\item{explicitExt}{set if you wish to override the default extension}

\item{outputDirectory}{directory in which output files are stored. Defaults to NULL, i.e.
the directory of the input files}

\item{forceToLog}{is set by the global package variable useWrasspLogger. This is set
to FALSE by default and should be set to TRUE is logging is desired.}

\item{verbose}{display infos & show progress bar}
}
\value{
nrOfProcessedFiles or if only one file to process return AsspDataObj of that file
}
\description{
rmsana function adapted from libassp
}
\details{
Analysis of short-term Root Mean Square amplitude of
the signal in <listOfFiles>. Per default, the RMS values are
expressed in decibel (dB) so that they correspond to
the short-term power of the signal.
Analysis results will be written to a file with the
base name of the input file and extension '.rms'.
Default output is in SSFF binary format (track 'rms').
}
\examples{
# get path to audio file
path2wav <- list.files(system.file("extdata", package = "wrassp"), 
                       pattern = glob2rx("*.wav"), 
                       full.names = TRUE)[1]

# calculate rms values
res <- rmsana(path2wav, toFile=FALSE)

# plot rms values
plot(seq(0,numRecs.AsspDataObj(res) - 1) / rate.AsspDataObj(res) +
       attr(res, 'startTime'),
     res$rms, 
     type='l', 
     xlab='time (s)', 
     ylab='RMS energy (dB)')

}
\author{
Raphael Winkelmann

Lasse Bombien
}
