% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixNAneighbourImpute.R
\name{.imputeNA}
\alias{.imputeNA}
\title{Basic NA-imputaton (main)}
\usage{
.imputeNA(
  dat,
  gr = NULL,
  impParam,
  exclNeg = TRUE,
  inclLowValMod = TRUE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{dat}{(matrix or data.frame) main data (may contain \code{NA})}

\item{gr}{(character or factor) grouping of columns of \code{dat}, replicate association}

\item{impParam}{(numeric) 1st for mean; 2nd for sd; 3rd for seed}

\item{exclNeg}{(logical) exclude negative}

\item{inclLowValMod}{(logical) label on x-axis on plot}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) supplemental messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a list with \code{$data} and \code{$datImp}
}
\description{
This (lower-level) function allows to perfom the basic NA-imputaton.
Note, at this point the information from argument \code{gr} is not used.
}
\examples{
dat1 <- matrix(11:22, ncol=4)
dat1[3:4] <- NA
.imputeNA(dat1, impParam=c(mean(dat1, na.rm=TRUE), 0.1))

}
\seealso{
for more complex treatment \code{\link{matrixNAneighbourImpute}};
}
