% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store.R
\name{store_json}
\alias{store_json}
\title{Store a JSON string in a workspace}
\usage{
store_json(
  x,
  json_str,
  filename,
  name = NULL,
  subdir,
  timestamp = format(Sys.time(), "\%Y-\%m-\%d \%H:\%M:\%S")
)
}
\arguments{
\item{x}{The workspace object.}

\item{json_str}{The JSON string to save in the workspace.}

\item{filename}{The name of the file used to store the JSON string in the workspace.}

\item{name}{name associated with the object, if a workspace file with this name exists
already it will be replaced.}

\item{subdir}{A subdirectory within the asset directory where the JSON file will be stored.}

\item{timestamp}{A timestamp string to associate with the entry in the workspace.}
}
\value{
Returns the \link{workspace} object passed to \code{x} parameter. Called primarily for side effects.
}
\description{
Saves a JSON string as a file in an existing workspace.

This function allows users to save JSON strings into a specified workspace.
The file is saved under the provided filename and can be organized within
a specific subdirectory for better management.
}
\examples{
library(workspace)
dir_tmp <- tempfile(pattern = "ws")
z <- new_workspace(dir = dir_tmp)

json_str <- paste0("{\"first_name\": \"John\",\"last_name\": \"Smith\",\"is_alive\": true,",
"\"age\": 27, \"address\": { \"street_address\": \"21 2nd Street\",",
"\"city\": \"New York\",\"state\": \"NY\",\"postal_code\": \"10021-3100\"",
"}}")
z <- store_json(
  x = z,
  json_str = json_str,
  filename = "example.json",
  timestamp = "2023-11-12 11:37:41",
  subdir = "blah"
)
z
}
\seealso{
\link{workspace} for package documentation

Other functions to write in a workspace: 
\code{\link{delete_dataset}()},
\code{\link{store_dataset}()},
\code{\link{store_raster}()},
\code{\link{store_rds}()},
\code{\link{store_yaml}()}
}
\concept{functions to write in a workspace}
