% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{betting}
\alias{betting}
\title{Betting function}
\usage{
betting(
  x,
  r,
  q,
  model,
  bets = "Best_odds",
  R = 2000,
  alpha = 0.1,
  start_oos = NULL,
  end_oos = NULL
)
}
\arguments{
\item{x}{an object of class 'welo', obtained from the \code{\link{welofit}} function}

\item{r}{Vector or scalar identifying the threshold of the ratio between the estimated and the implied probability (see above)}

\item{q}{Scalar parameter used to exclude the heavy underdogs signalled by Bet365 bookmaker.
No bets will be placed on those matches where players have implied probabilities smaller than \eqn{q}}

\item{model}{Valid choices are: "WELO" and "ELO"}

\item{bets}{\strong{optional} Parameter identifying on which type of odds the bet is placed. Default to "Best_odds". Valid choices are:
"Best_odds", "Avg_odds" and "B365_odds". "Best_odds" are the highest odds available. "Avg_odds" are the average odds for that match and
"B365_odds" are the Bet365 odds}

\item{R}{\strong{optional} Number of bootstrap replicates to calculate the confidence intervals. Default to 2000}

\item{alpha}{\strong{optional} Significance level for the boostrap confidence intervals. Default to 0.1}

\item{start_oos}{\strong{optional} Character parameter denoting the starting year for the bets.
If included (default to NULL), then the bets will be placed on matches starting in that year. It has to be formatted as "YYYY"}

\item{end_oos}{\strong{optional} Character parameter denoting the ending year for the bets.
If included (default to NULL), then the bets will be placed on matches included in the period "start_oos/end_oos".
It has to be formatted as "YYYY"}
}
\value{
A matrix including the number of bets placed, the Return-on-Investiment (ROI), expressed in percentage, and its boostrap confidence interval,
calculated using \eqn{R} replicates and the significance level \eqn{\alpha}.
}
\description{
Places bets using the WElo and Elo probabilities, on the basis of two thresholds \eqn{r} and \eqn{q}, according to \insertCite{angelini2021weighted;textual}{welo}.
By default, the amount of $1 is placed on the best odds (that is, the highest odds available) for player \eqn{i} for all
the matches where it holds that
\deqn{\frac{\hat{p}_{i,j}(t)}{q_{i,j}(t)} > r,}
where \eqn{\hat{p}_{i,j}(t)} is the estimated probability (coming from the WElo or Elo model) that player \eqn{i} wins the match \eqn{t} against player \eqn{j}
and \eqn{q_{i,j}(t)} is its implied probability obtained as the reciprical of the Bet365 odds. The implied
probability \eqn{q_{i,j}(t)} is assumed to be greater than \eqn{q}. If \eqn{q=0}, all the players are considered. If \eqn{q} increases,
heavy longshot players are excluded.
In general, higher thresholds \eqn{r} and \eqn{q} imply less betting opportunities.
}
\examples{
\donttest{
data(atp_2019) 
db_clean<-clean(atp_2019)
db_est<-welofit(db_clean)
bets<-betting(db_est,r=c(1.1,1.2,1.3),q=0.3,model="WELO")
bets
}
}
