% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{tennis_prob}
\alias{tennis_prob}
\title{Probability of winning}
\usage{
tennis_prob(i, j)
}
\arguments{
\item{i}{WElo or Elo rates for player \eqn{i}}

\item{j}{WElo or Elo rates for player \eqn{j}}
}
\value{
Probability that player \eqn{i} wins the match against player \eqn{j}
}
\description{
Calculates the probability that player \eqn{i} wins over player \eqn{j} for match at time \eqn{t+1} using the WElo or Elo rates at time \eqn{t}. Formally:
\deqn{\hat{p}_{i,j}(t+1) = \frac{1}{1+10^{\left(E_j(t)-E_i(t)\right)/400}},}
where \eqn{E_{i}(t)} and \eqn{E_j(t)} are the WElo or Elo rates at time \eqn{t}.
}
\examples{
tennis_prob(2000,2000) 
tennis_prob(2500,2000)
}
