% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wdpa_url.R
\name{wdpa_url}
\alias{wdpa_url}
\title{Download URL}
\usage{
wdpa_url(x, wait = FALSE, page_wait = 2)
}
\arguments{
\item{x}{\code{character} country for desired data. This argument
can be the name of the country (e.g. \code{"Liechtenstein"}) or the
ISO-3 code for the country (e.g. \code{"LIE"}). This argument can also
be set to \code{"global"} to obtain the URL for the global dataset.}

\item{wait}{\code{logical} if data is not immediately available for download
should the session be paused until it is ready for download? If argument
to \code{wait} is \code{FALSE} and the data is not ready then an error
will be thrown. Defaults to \code{FALSE}.}

\item{page_wait}{\code{numeric} number of seconds to wait for web pages
to load when finding the download URL on
\href{https://www.protectedplanet.net/en}{Protected Planet}.
Defaults to 2.
Since the process of finding a download URL requires
navigating through multiple web pages,
the default argument means that the function will take at least 8
seconds to complete.
Users on slow internet connections may experience issues
with the default argument (e.g. resulting in an error
containing the message \code{Error: Summary: NoSuchElement}).
To avoid this, users can try specifying a greater value (e.g. 5 seconds).}
}
\value{
\code{character} URL to download the data.
}
\description{
Obtain a URL to download data from
\href{https://www.protectedplanet.net/en}{Protected Planet}.
Specifically, the URL provides access to data available through
the World Database on Protected Areas
(WDPA) and the World Database on Other Effective Area-Based Conservation
Measures (WDOECM).
\strong{Note that data are accessed assuming non-commercial use.}
}
\examples{
\dontrun{
# obtain url for New Zealand data
nzl_url <- wdpa_url("New Zealand", wait = TRUE)
print(nzl_url)

# obtain url for New Zealand data using its ISO3 code
nzl_url <- wdpa_url("NZL", wait = TRUE)
print(nzl_url)

# obtain url for global data
global_url <- wdpa_url("global")
print(global_url)
}
}
\seealso{
\code{\link[=wdpa_fetch]{wdpa_fetch()}}, \code{\link[countrycode:countrycode]{countrycode::countrycode()}}.
}
