% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizations.R
\name{oneRasterPlot}
\alias{oneRasterPlot}
\title{Single raster plot}
\usage{
oneRasterPlot(rast, land = NA, landCol = "black", title = "A Raster", ...)
}
\arguments{
\item{rast}{A single \verb{Raster*} layer on a continuous
scale.}

\item{land}{An optional coastline polygon shapefile
of type \code{sf} to provide geographic context for the
occurrence points.}

\item{landCol}{Color for land on map.}

\item{title}{A title for the plot.}

\item{...}{Additional optional arguments to pass to
\code{spplot} initial plot object or \code{viridis}.}
}
\value{
A plot of class \code{trellis} mapping the values
of the input raster layer
}
\description{
A convenient wrapper around \code{spplot}
to generate a formatted plot of a single raster.
}
\examples{
library(raster)
rast <- raster(ncol=10, nrow=10)
values(rast) <- seq(0,99, 1)

oneRasterPlot(rast = rast)

}
\seealso{
\code{\link[viridisLite:viridis]{viridis}} \code{\link[raster:spplot]{spplot}}
}
\keyword{plotting}
