% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onestep_based_estimator.R
\name{onestep_based_estimator}
\alias{onestep_based_estimator}
\title{Estimate variable importance using a one-step estimator-based approach}
\usage{
onestep_based_estimator(full, reduced, y, type = "regression",
  na.rm = FALSE)
}
\arguments{
\item{full}{fitted values from a regression of the outcome on the full set of covariates.}

\item{reduced}{fitted values from a regression of the fitted values from the full regression on the reduced set of covariates.}

\item{y}{the outcome.}

\item{type}{which parameter are you estimating (defaults to \code{regression}, for ANOVA-based variable importance)?}

\item{na.rm}{logical; should NA's be removed in computation? (defaults to \code{FALSE})}
}
\value{
The estimated variable importance for the given group of left-out covariates.
}
\description{
Compute nonparametric estimates of the variable importance parameter interpreted as the proportion of variability explained by including a group of covariates in the estimation technique.
}
\details{
See the paper by Williamson, Gilbert, Simon, and Carone for more
details on the mathematics behind this function and the definition of the parameter of interest.
}
