% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subscript.R
\name{vec_as_subscript}
\alias{vec_as_subscript}
\alias{vec_as_subscript2}
\title{Convert to a base subscript type}
\usage{
vec_as_subscript(
  i,
  ...,
  logical = c("cast", "error"),
  numeric = c("cast", "error"),
  character = c("cast", "error"),
  arg = NULL,
  call = caller_env()
)

vec_as_subscript2(
  i,
  ...,
  logical = c("cast", "error"),
  numeric = c("cast", "error"),
  character = c("cast", "error"),
  arg = NULL,
  call = caller_env()
)
}
\arguments{
\item{i}{An integer, character or logical vector specifying the
locations or names of the observations to get/set. Specify
\code{TRUE} to index all elements (as in \code{x[]}), or \code{NULL}, \code{FALSE} or
\code{integer()} to index none (as in \code{x[NULL]}).}

\item{...}{These dots are for future extensions and must be empty.}

\item{logical, location, character}{How to handle logical, numeric,
and character subscripts.

If \code{"cast"} and the subscript is not one of the three base types
(logical, integer or character), the subscript is
\link[=vec_cast]{cast} to the relevant base type, e.g. factors are
coerced to character. \code{NULL} is treated as an empty integer
vector, and is thus coercible depending on the setting of
\code{numeric}. Symbols are treated as character vectors and thus
coercible depending on the setting of \code{character}.

If \code{"error"}, the subscript type is disallowed and triggers an
informative error.}

\item{arg}{The argument name to be displayed in error messages when
\code{vec_as_location()} and \code{vec_as_location2()} are used to check the
type of a function input.}

\item{call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Convert \code{i} to the base type expected by \code{\link[=vec_as_location]{vec_as_location()}} or
\code{\link[=vec_as_location2]{vec_as_location2()}}. The values of the subscript type are
not checked in any way (length, missingness, negative elements).
}
\keyword{internal}
