% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chromR_functions.R
\name{chromR functions}
\alias{chromR functions}
\alias{masker}
\alias{variant.table}
\alias{win.table}
\title{chromR_functions}
\usage{
masker(x, min_QUAL = 1, min_DP = 1, max_DP = 10000, min_MQ = 20,
  max_MQ = 100, preserve = FALSE, ...)

variant.table(x)

win.table(x)
}
\arguments{
\item{x}{object of class chromR}

\item{min_QUAL}{minimum variant quality}

\item{min_DP}{minimum cumulative depth}

\item{max_DP}{maximum cumulative depth}

\item{min_MQ}{minimum mapping quality}

\item{max_MQ}{maximum mapping quality}

\item{preserve}{a logical indicating whether or not to preserve the state of
the current mask field. Defaults to \code{FALSE}}

\item{...}{arguments to be passed to methods}
}
\description{
Functions which act on chromR objects
}
\details{
The function \strong{masker} creates a logical vector that determines which variants are masked.
By masking certain variants, instead of deleting them, it preserves the dimensions of the data structure until a change needs to be committed.
Variants can be masked based on the value of the QUAL column of the vcf object.
Experience seems to show that this value is either at its maximum (999) or a rather low value.
The maximum and minimum sequence depth can also be used (mindp and maxdp).
The default is to mask all variants with depths of less than the 0.25 quantile and greater than the 0.75 quantile (these are also known as the lower and upper quartile).
The minimum and maximum mapping qualities (minmq, maxmq) can also be used.


This vector is stored in the var.info$mask slot of a chromR object.

The function \strong{variant.table} creates a data.frame containing information about variants.

The funciton \strong{win.table}
}
