\name{plot.varfevd}

\alias{plot.varfevd}

\encoding{latin1}

\title{Plot method for objects of class varfevd}

\description{
  Plots of the forecast error variance decomposition are displayed as a
  barplot per variable. 
}

\usage{
\method{plot}{varfevd}(x, ...)
}

\arguments{
  \item{x}{An object of class \sQuote{\code{varfevd}}, generated by
    \command{fevd()}.} 
  \item{\dots}{Currently not used.}
}

\author{Bernhard Pfaff}

\references{
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York.
}

\seealso{
  \code{\link{fevd}}
}
\examples{
\dontrun{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
var.2c.fevd <- fevd(var.2c, n.ahead = 5)
plot(var.2c.fevd)
}
}

\keyword{regression}
