\name{BQ}
\alias{BQ}
\title{Estimates a Blanchard-Quah type SVAR}
\encoding{latin1}
\description{
  This function estimates a SVAR of type Blanchard and Quah. It returns
  a list object with class attribute \sQuote{\code{svarest}}.
}
\usage{
BQ(x)
}
\arguments{
  \item{x}{Object of class \sQuote{\code{varest}}; generated by
    \command{VAR()}.}
}
\details{
  For a Blanchard-Quah model the matrix \eqn{A} is set to be an identity
  matrix with dimension \eqn{K}. The matrix of the long-run effects is
  assumed to be lower-triangular and is defined as:

  \deqn{
    (I_K - A_1 - \cdots - A_p)^{-1}B
  }

  Hence, the residual of the second equation cannot exert a long-run
  influence on the first variable and likewise the third residual cannot
  impact the first and second variable. The estimation of the
  Blanchard-Quah model is achieved by a Choleski decomposition of:

  \deqn{
    (I_K - \hat{A}_1 - \cdots - \hat{A}_p)^{-1}\hat{\Sigma}_u (I_K -
    \hat{A}_1' - \cdots - \hat{A}_p')^{-1}
  }

  The matrices \eqn{\hat{A}_i} for \eqn{i = 1, \ldots, p} assign the
  reduced form estimates. The long-run impact matrix is the
  lower-triangular Choleski decomposition of the above matrix and the
  contemporaneous impact matrix is equal to:

  \deqn{
    (I_K - A_1 - \cdots - A_p)Q
  }
  where \eqn{Q} assigns the lower-trinagular Choleski decomposition.
}
\value{
  A list of class \sQuote{\code{svarest}} with the following elements is
  returned:\cr
  
  \item{A}{An identity matrix.}
  \item{Ase}{\code{NULL}.}
  \item{B}{The estimated contemporaneous impact matrix.}
  \item{Bse}{\code{NULL}.}
  \item{LRIM}{The estimated long-run impact matrix.}  
  \item{Sigma.U}{The variance-covariance matrix of the reduced form
    residuals times 100.}
  \item{LR}{\code{NULL}.}
  \item{opt}{\code{NULL}.}
  \item{start}{\code{NULL}.}
  \item{type}{Character: \dQuote{Blanchard-Quah}.}
  \item{var}{The \sQuote{\code{varest}} object \sQuote{\code{x}}.} 
  \item{call}{The \code{call} to \command{BQ()}.}  
}
\references{
  Blanchard, O. and D. Quah (1989), The Dynamic Effects of Aggregate
  Demand and Supply Disturbances, \emph{The American Economic Review},
  \bold{79}(4), 655-673.
  
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York.
}
\author{Bernhard Pfaff}
\seealso{\code{\link{SVAR}}, \code{\link{VAR}}}
\examples{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
BQ(var.2c)
}
\keyword{regression}
\concept{SVAR}
\concept{Structural VAR}
\concept{Structural Vector Autoregressive}
\concept{Blanchard-Quah}
