library(uwot)
context("Epochs")


V <- fuzzy_simplicial_set(nn = nn)

n_epochs <- 500
V@x[V@x < max(V@x) / n_epochs] <- 0
V <- Matrix::drop0(V)
expect_equal(make_epochs_per_sample(V@x, n_epochs),
  c(
    1.0, 1.0, 1.0, 6.1763447, 1.44948659, 2.16709542,
    2.35197392, 1.0, 1.44948659, 1.0, 1.0, 1.73965964,
    2.00000768, 2.16709542, 1.0, 1.54738133, 1.0, 1.37424666,
    1.0, 1.0, 3.56216605, 1.09552314, 1.0, 1.0,
    1.0, 1.54738133, 3.56216605, 2.82683975, 1.0, 1.09552314,
    2.82683975, 3.21967221, 2.35197392, 1.73965964, 1.0, 6.1763447,
    1.0, 2.00000768, 1.37424666, 3.21967221
  ),
  tol = 1e-5
)
