% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_def_2.R
\docType{data}
\name{pal_unikn}
\alias{pal_unikn}
\title{unikn default color palette (11 colors).}
\format{
An object of class \code{data.frame} with 1 rows and 11 columns.
}
\usage{
pal_unikn
}
\description{
\code{pal_unikn} combines the 5 shades of blue colors 
from color palette \code{\link{pal_seeblau}} 
with the 6 non-blue colors of \code{\link{pal_unikn_web}} 
to a palette containing 11 color values.
}
\details{
Adding seeblau5 (i.e., \code{pal_seeblau[1]}) to 
the default color palette \code{\link{pal_unikn}} 
also puts \code{white} at the central (middle) 
position of a palette with 11 values:

\code{pal_unikn[[6]]} is \code{white} or \code{"#FFFFFF"}.  

This is useful when creating color gradients. 

See \url{https://www.uni-konstanz.de/en/university/news-and-media/create-online-and-print-media/corporate-design/} for details.
}
\examples{
pal_unikn
dim(pal_unikn)  # 1 11

# Access by position:
pal_unikn[1]    # new color "seeblau5" (as df)
pal_unikn[[1]]  # new color value "#008ECE"

# Access by name: 
pal_unikn["seeblau5"]   # new color "seeblau5" (as df) 
pal_unikn[["seeblau5"]] # new color value "#008ECE"

# Viewing/using color palette:
seecol(pal_unikn)
demopal(pal_unikn, type = "curve", main = "Default colors of Konstanz University")

# Note:
pal_unikn[6] # "white" or "#FFFFFF" as central of 11 colors

}
\seealso{
\code{\link{pal_unikn}} for the default uni.kn color palette; 
\code{\link{pal_seeblau}} for the uni.kn seeblau color palette; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes.

Other color palettes: 
\code{\link{pal_bordeaux}},
\code{\link{pal_grau}},
\code{\link{pal_karpfenblau}},
\code{\link{pal_peach}},
\code{\link{pal_petrol}},
\code{\link{pal_pinky}},
\code{\link{pal_seeblau}},
\code{\link{pal_seegruen}},
\code{\link{pal_signal}},
\code{\link{pal_unikn_dark}},
\code{\link{pal_unikn_light}},
\code{\link{pal_unikn_pair}},
\code{\link{pal_unikn_ppt}},
\code{\link{pal_unikn_pref}},
\code{\link{pal_unikn_web}}
}
\concept{color palettes}
\keyword{datasets}
