% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Minnesota_Twin_Cities.R
\docType{data}
\name{minnesotatwin_1}
\alias{minnesotatwin_1}
\title{Primary colors of the University of Minnesota Twin Cities, USA}
\format{
An object of class \code{character} of length 2.
}
\source{
Color definitions are based on the 
\href{https://university-relations.umn.edu/resources/colors-and-type}{UMN website}.
}
\usage{
minnesotatwin_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{minnesotatwin_1} provides the two primary colors
of the \href{https://twin-cities.umn.edu/}{University of Minnesota}, USA.
}
\details{
The 2 primary colors are
\code{"minnesotatwin_maroon"} (defined as HEX #7A0019) and
\code{"minnesotatwin_gold"} (defined as HEX #FFCC33).

\code{minnesotatwin_1} uses the HEX color definitions.
}
\examples{
minnesotatwin_1
unikn::seecol(minnesotatwin_1, 
              main = "University of Minnesota Twin Cities") # view color palette


}
\seealso{
\code{\link{minnesotatwin_2}} for the secondary colors of UMN;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other university of color palettes: 
\code{\link{glasgow_1}},
\code{\link{glasgow_2}}
}
\author{
\strong{unicol}, 2023-07-01.
}
\concept{university of color palettes}
\keyword{datasets}
