% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{SAM-class}
\alias{SAM-class}
\title{Sam Prediction}
\value{
An S4 object of class SAM
}
\description{
The class holds the resuls of the Spectral Angle Mapping algorithm and it originates by a call to \code{\link{tile_sam}} or to \code{\link{mosaic_compose}}. It has three slots with congruent cubes. Each cube has its first two dimensions equal to the FPA size of the uFTIR Microscope image processed and the third dimension equal to the number of substances in the \code{\link[=SpectralReference-class]{SpectralReference}} passed when calling \code{\link{tile_sam}} or \code{\link{mosaic_sam}}. This class have methods to plot, summarize, and extract the readings of pixel matching a given SpectralReference substance. You can use the generics \code{\link[graphics]{plot}}, \code{\link[base]{summary}}, and \code{\link{get_profile}} but beware, you might have to provide extra arguments! (so, please don't see only the generic but the method for this class, see the section see also)

The \code{\link[=SAM-class]{sam}} object can be postprocessed by calling \code{\link{smooth_sam}} and/or clipped to a given extent by calling \code{\link{clipper}} (currently only circular extents are supported).
}
\section{Slots}{

\describe{
\item{\code{raw_sam}}{a cube -array-. The numeric score for each \code{\link[=SpectralReference-class]{SpectralReference}} substance passed by the call (slices), for each pixel of the FPA array of the \code{\link[=Tile-class]{Tile}} (rows and cols).}

\item{\code{substances}}{a cube -array-. The slices of the cube hold the substances (as number) of the \code{\link[=SpectralReference-class]{SpectralReference}} object passed when calling \code{\link{tile_sam}} or \code{\link{mosaic_sam}}. The substance number are sorted in a decreacing order. In this way, the first slide is the best match, the second the second-best, and so on according to the Spectral Angle Mapping algorithm.}

\item{\code{clusters}}{a cube -array-. Equivalent to the cube in the substances slot but instead of a substance number it has per ech slice the cluster number that corresponds to the clusterlist slot of the \code{\link[=SpectralReference-class]{SpectralReference}} object.}
}}

\examples{
NULL
}
\seealso{
\code{\link{plot_tile}} \code{\link{summary_sam}} \code{\link{get_profile_tile}} \code{\link{get_profile_sinfo}}
}
