% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLE_functions.R
\name{predicttsir}
\alias{predicttsir}
\title{predicttsir}
\usage{
predicttsir(times, births, beta, alpha, S0, I0, nsim, stochastic)
}
\arguments{
\item{times}{The time vector to predict the model from. This assumes that the time step is equal to IP}

\item{births}{The birth vector (of length length(times) or a single element) where each element is the births in that given (52/IP) time step}

\item{beta}{The length(52/IP) beta vector of contact.}

\item{alpha}{A single numeric which acts as the homogeniety parameter.}

\item{S0}{The starting initial condition for S. This should be greater than one, i.e. not a fraction.}

\item{I0}{The starting initial condition for I. This should be greater than one, i.e. not a fraction.}

\item{nsim}{The number of simulations to perform.}

\item{stochastic}{A TRUE / FALSE argument where FALSE is the deterministic model, and TRUE is a negative binomial distribution.}
}
\description{
function to predict incidence and susceptibles using the tsir model. This is different than
simulatetsir as you are inputting parameters as vectors. The output is a data frame I and S with mean and confidence intervals of predictions.
}
\examples{
\dontrun{
require(kernlab)
require(ggplot2)
require(kernlab)
require(tsiR)
London <- twentymeas$London

London <- subset(London, time > 1950)

IP <- 2
## first estimate paramters from the London data
parms <- estpars(data=London, IP=2, regtype='gaussian')

plotbeta(parms)

## now lets predict forward 20 years using the mean birth rate,
## starting from rough initial conditions
births <- min(London$births)
times <- seq(1965,1985, by = 1/ (52/IP))
S0 <- parms$sbar
I0 <- 1e-5*mean(London$pop)

pred <- predicttsir(times=times,births=births,
                    beta=parms$contact$beta,alpha=parms$alpha,
                    S0=S0,I0=I0,
                    nsim=50,stochastic=T)

## plot this prediction
ggplot(pred$I,aes(time,mean))+geom_line()+geom_ribbon(aes(ymin=low,ymax=high),alpha=0.3)


}
}
