% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.R
\name{relaxedClockTest}
\alias{relaxedClockTest}
\title{Use parametric bootstrap to test if relaxed clock offers improved fit to data.}
\usage{
relaxedClockTest(..., nreps = 100, overrideTempConstraint = T,
  ncpu = 1)
}
\arguments{
\item{...}{arguments passed to *dater*}

\item{nreps}{Integer number of simulations}

\item{overrideTempConstraint}{see *parboot*}

\item{ncpu}{Number of threads to use for parallel computation. Recommended.}
}
\value{
A list with elements:
\itemize{
\item strict_treedater: A dater object under a strict clock
\item relaxed_treedater: A dater object under a relaxed clock
\item clock: The favoured clock model 
\item parboot: Result of call to *parboot* using fitted treedater and forcing a relaxed clock
\item nullHypothesis_coef_of_variation_CI: The null hypothesis CV
}
}
\description{
This function simulates phylogenies with branch lengths in units
     of substitutions per site. Simulations are based on a fitted
     treedater object which provides parameters of the molecular clock
     model. The coefficient of variation of rates is estimated using a
     relaxed clock model applied to strict clock simulations. Estimates
     of the CV is then compared to the null distribution provided by
     simulations.
}
\details{
This function will print the optimal clock model
     and the distribution of the coefficient of variation statistic under the null hypothesis (strict
     clock). Parameters passed to this function should be the same as when calling *dater*.
}
\examples{
# simulate a tree 
tre <- ape::rtree(25)
# sample times based on distance from root to tip:
sts <- setNames( ape::node.depth.edgelength( tre )[1:ape::Ntip(tre)], tre$tip.label)
# modify edge length to represent evolutionary distance with rate 1e-3:
tre$edge.length <- tre$edge.length * 1e-3
relaxedClockTest( tre, sts, s= 1000,  omega0=.0015 , nreps=25)


}
\author{
Erik M Volz <erik.volz@gmail.com>
}
