% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{predict.transreg}
\alias{predict.transreg}
\title{Make Predictions}
\usage{
\method{predict}{transreg}(object, newx, stack = NULL, ...)
}
\arguments{
\item{object}{object of class `transreg`}

\item{newx}{features:
matrix with \eqn{n} rows (samples) and \eqn{p} columns (variables)}

\item{stack}{character "sta" (standard stacking) or "sim" (simultaneous stacking)}

\item{...}{(not applicable)}
}
\value{
Returns predicted values or predicted probabilities.
The output is a column vector with one entry for each sample.
}
\description{
Predicts outcome
}
\examples{
#--- simulation ---
set.seed(1)
n0 <- 100; n1 <- 10000; n <- n0 + n1; p <- 500
X <- matrix(rnorm(n=n*p),nrow=n,ncol=p)
beta <- rnorm(p)
prior <- beta + rnorm(p)
y <- X \%*\% beta

#--- train-test split ---
foldid <- rep(c(0,1),times=c(n0,n1))
y0 <- y[foldid==0]
X0 <- X[foldid==0,]
y1 <- y[foldid==1]
X1 <- X[foldid==1,]

#--- glmnet (without prior effects) ---
object <- glmnet::cv.glmnet(y=y0,x=X0)
y_hat <- predict(object,newx=X1,s="lambda.min")
mean((y1-y_hat)^2)

#--- transreg (with prior effects) ---
object <- transreg(y=y0,X=X0,prior=prior)
y_hat <- predict(object,newx=X1)
mean((y1-y_hat)^2) # decrease in MSE?

}
\references{
\href{https://orcid.org/0000-0001-6498-4801}{Armin Rauschenberger},
\href{https://orcid.org/0000-0002-2327-3904}{Zied Landoulsi},
\href{https://orcid.org/0000-0003-4780-8472}{Mark A. van de Wiel},
and
\href{https://orcid.org/0000-0003-3977-7469}{Enrico Glaab}
(2023).
"Penalised regression with multiple sets of prior effects".
\emph{Bioinformatics} 39(12):btad680.
\doi{10.1093/bioinformatics/btad680}.
(Click
\href{https://orbilu.uni.lu/bitstream/10993/53227/1/transreg.pdf}{here}
to access PDF.)
}
\seealso{
Methods for objects of class [transreg]
include \code{\link[=coef.transreg]{coef}} 
and \code{\link[=predict.transreg]{predict}}.
}
