% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files_manager.R
\name{render_file}
\alias{render_file}
\title{Render file from Google Drive}
\usage{
render_file(
  file,
  gfile = basename(file),
  gpath = "trackdown",
  shared_drive = NULL
)
}
\arguments{
\item{file}{character. The path of a local `.Rmd` or `.Rnw` file.}

\item{gfile}{character. The name of a Google Drive file (defaults to local
file name).}

\item{gpath}{character. (Sub)directory in My Drive or a shared drive
(optional). By default files are uploaded in the folder "trackdown". To
specify another folder the full path is required (e.g., 
"trackdown/my_folder"). Use \code{NULL} to upload directly at the root
level, although it is not recommended.}

\item{shared_drive}{character. The name of a Google Drive shared drive
(optional).}
}
\value{
`TRUE` if file from Google Drive was saved and rendered, `FALSE`
  otherwise
}
\description{
Render file from Google Drive if there have been edits\cr\cr
To know more about \code{trackdown} workflow and features see
\code{\link{trackdown-package}} help page.
}
