% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-init.R
\name{nn_init_sparse_}
\alias{nn_init_sparse_}
\title{Sparse initialization}
\usage{
nn_init_sparse_(tensor, sparsity, std = 0.01)
}
\arguments{
\item{tensor}{an n-dimensional \code{Tensor}}

\item{sparsity}{The fraction of elements in each column to be set to zero}

\item{std}{the standard deviation of the normal distribution used to generate
the non-zero values}
}
\description{
Fills the 2D input \code{Tensor} as a sparse matrix, where the
non-zero elements will be drawn from the normal distribution
as described in \verb{Deep learning via Hessian-free optimization} - Martens, J. (2010).
}
\examples{
if (torch_is_installed()) {
\dontrun{
w <- torch_empty(3, 5)
nn_init_sparse_(w, sparsity = 0.1)
}
}
}
