% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-style.R
\name{grid_style_column}
\alias{grid_style_column}
\title{Set column style}
\usage{
grid_style_column(
  grid,
  column,
  background = NULL,
  color = NULL,
  fontWeight = NULL,
  ...
)
}
\arguments{
\item{grid}{A grid created with \code{\link[=datagrid]{datagrid()}}.}

\item{column}{Name of column (variable name) where to apply style.}

\item{background}{Background color.}

\item{color}{Text color.}

\item{fontWeight}{Font weight, you can use \code{"bold"} for example.}

\item{...}{Other CSS properties.}
}
\value{
A \code{datagrid} htmlwidget.
}
\description{
Apply styles to a column according to CSS properties
declared by expression based on data passed to grid..
}
\examples{

library(toastui)
library(scales)

datagrid(mtcars) \%>\%
  grid_style_column(
    column = "mpg",
    background = col_numeric("Blues", domain = NULL)(mpg),
    fontWeight = "bold",
    color = ifelse(mpg > 25, "white", "black")
  )

datagrid(mtcars) \%>\%
  grid_style_column(
    column = "mpg",
    background = col_numeric("Blues", domain = NULL)(mpg),
    fontWeight = "bold",
    color = ifelse(mpg > 25, "white", "black")
  ) \%>\%
  grid_style_column(
    column = "cyl",
    background = col_bin("Blues", domain = NULL)(cyl),
    fontStyle = "italic"
  )
}
