% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop_shape.R
\name{crop_shape}
\alias{crop_shape}
\title{Crop shape object}
\usage{
crop_shape(x, y, polygon = FALSE, ...)
}
\arguments{
\item{x}{shape object, i.e. an object from class \code{\link[sf:sf]{sf}}, \code{\link[stars:st_as_stars]{stars}}, \code{sp}, or \code{raster}.}

\item{y}{bounding box, an \code{\link[sf:st_bbox]{st_bbox}},  \code{extent} (\code{raster} package), or a shape object from which the bounding box is extracted (unless \code{polygon} is \code{TRUE} and \code{x} is an \code{sf} object).}

\item{polygon}{should \code{x} be cropped by the polygon defined by \code{y}? If \code{FALSE} (default), \code{x} is cropped by the bounding box of \code{x}. Polygon cropping only works when \code{x} is a spatial object and \code{y} is a \code{SpatialPolygons} object.}

\item{...}{not used anymore}
}
\value{
cropped shape, in the same class as \code{x}
}
\description{
Crop a shape object (from class \code{\link[sf:sf]{sf}}, \code{\link[stars:st_as_stars]{stars}}, \code{sp}, or \code{raster}). A shape file \code{x} is cropped, either by the bounding box of another shape \code{y}, or by \code{y} itself if it is a SpatialPolygons object and \code{polygon = TRUE}.
}
\details{
This function is similar to \code{crop} from the \code{raster} package. The main difference is that \code{crop_shape} also allows to crop using a polygon instead of a rectangle.
}
\examples{
if (require(tmap) && packageVersion("tmap") >= "2.0") {
    data(World, NLD_muni, land, metro)

    #land_NLD <- crop_shape(land, NLD_muni)

    #qtm(land_NLD, raster="trees", style="natural")

    metro_Europe <- crop_shape(metro, World[World$continent == "Europe", ], polygon = TRUE)

    qtm(World) +
    tm_shape(metro_Europe) +
    	tm_bubbles("pop2010", col="red", title.size="European cities") +
    	tm_legend(frame=TRUE)
}
}
\seealso{
\code{\link{bb}}
}
