% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minhash_v2.R
\name{minhash_v2}
\alias{minhash_v2}
\title{Function to create a matrix of minhashed signatures}
\usage{
minhash_v2(
  shingled_records,
  p,
  do_one_hash_and_record = do_one_hash_and_record
)
}
\arguments{
\item{shingled_records}{Shingled records}

\item{p}{Number of permutations to be applied to the hash function}

\item{do_one_hash_and_record}{Combination of one hash and one record}
}
\value{
Computes an integer-valued matrix of minhash signatures with one row per permutation and one column per record
}
\description{
Function to create a matrix of minhashed signatures
}
\examples{
head(data <- RLdata500[-c(2,4)])
minidata <- data[1:2,]
head(all_the_shingles <- apply(minidata,1,shingles,k=8))
head(minhash.minidata <- minhash_v2(all_the_shingles, p=10))
}
