% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show.R
\name{provision_isolation}
\alias{provision_isolation}
\title{Create a document and list of nodes to isolate}
\usage{
provision_isolation(nodelist)
}
\arguments{
\item{nodelist}{an object of class \code{xml_nodeset} OR \code{xml_node} OR a list of
either.}
}
\value{
a list of three elements:
\itemize{
\item doc: a copy of the document with the nodes isolated depending on the
context
\item key: a string used to tag nodes that are isolated via the \code{tnk-key}
attribute.
\item unrelated: an \code{xml_nodeset} containing nodes that have no ancestor,
descendant, or self relationship to the nodes in \code{nodelist}.
}
}
\description{
This uses \code{\link[xml2:xml_children]{xml2::xml_root()}} and \code{\link[xml2:xml_path]{xml2::xml_path()}} to make a copy of the
root document and then tag the corresponding nodes in the nodelist so that
we can filter on nodes that are not connected to those present in the
nodelist. This function is required for \code{\link[=isolate_nodes]{isolate_nodes()}} to work.
}
\examples{
\dontshow{if (isTRUE(as.logical(Sys.getenv("NOT_CRAN", "false")))) withAutoprint(\{ # examplesIf}
path <- system.file("extdata", "show-example.md", package = "tinkr")
y <- tinkr::yarn$new(path, sourcepos = TRUE)
y$protect_math()$protect_curly()
items <- xml2::xml_find_all(y$body, ".//md:item", tinkr::md_ns())
tnk <- asNamespace("tinkr")
tnk$provision_isolation(items)
\dontshow{\}) # examplesIf}
}
\seealso{
Other nodeset isolation functions: 
\code{\link{isolate_nodes}()}
}
\concept{nodeset isolation functions}
\keyword{internal}
