% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_t_shift_by_arm_by_worst.R
\name{template_shift_by_arm_by_worst}
\alias{template_shift_by_arm_by_worst}
\title{Template: Shift by Arm by Worst Analysis Indicator Level}
\usage{
template_shift_by_arm_by_worst(
  dataname,
  parentname,
  arm_var = "ARM",
  paramcd = "PARAMCD",
  worst_flag_var = "WORS02FL",
  worst_flag = "Y",
  treatment_flag_var = "ONTRTFL",
  treatment_flag = "Y",
  aval_var = "ANRIND",
  base_var = lifecycle::deprecated(),
  baseline_var = "BNRIND",
  na.rm = FALSE,
  na_level = default_na_str(),
  add_total = FALSE,
  total_label = default_total_label(),
  basic_table_args = teal.widgets::basic_table_args()
)
}
\arguments{
\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{arm_var}{(\code{character})\cr variable names that can be used as \code{arm_var}.}

\item{paramcd}{(\code{character})\cr name of the parameter code variable.}

\item{worst_flag_var}{(\code{character})\cr name of the worst flag variable.}

\item{worst_flag}{(\code{character})\cr value indicating worst analysis indicator level.}

\item{treatment_flag_var}{(\code{character})\cr name of the on treatment flag variable.}

\item{treatment_flag}{(\code{character})\cr name of the value indicating on treatment
records in \code{treatment_flag_var}.}

\item{aval_var}{(\code{character})\cr name of the analysis reference range indicator variable.}

\item{base_var}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use the \code{baseline_var} argument instead.}

\item{baseline_var}{(\code{character})\cr name of the baseline reference range indicator variable.}

\item{na.rm}{(\code{logical})\cr whether \code{NA} values should be removed prior to analysis.}

\item{na_level}{(\code{string})\cr used to replace all \code{NA} or empty values
in character or factor variables in the data. Defaults to \code{"<Missing>"}. To set a
default \code{na_level} to apply in all modules, run \code{set_default_na_str("new_default")}.}

\item{add_total}{(\code{logical})\cr whether to include row with total number of patients.}

\item{total_label}{(\code{string})\cr string to display as total column/row label if column/row is
enabled (see \code{add_total}). Defaults to \code{"All Patients"}. To set a new default \code{total_label} to
apply in all modules, run \code{set_default_total_label("new_default")}.}

\item{basic_table_args}{optional, (\code{basic_table_args})\cr object created by \code{\link[teal.widgets:basic_table_args]{teal.widgets::basic_table_args()}}
with settings for the module table. The argument is merged with option \code{teal.basic_table_args} and with default
module arguments (hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-basic-table-arguments", package = "teal.widgets")}.}
}
\value{
a \code{list} of expressions to generate a table or plot object.
}
\description{
Creates a valid expression to generate a summary table of worst analysis indicator variable level per subject by arm.
}
\seealso{
\code{\link[=tm_t_shift_by_arm]{tm_t_shift_by_arm()}}
}
\keyword{internal}
