% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcplggplot2.R
\name{tcplggplot2}
\alias{tcplggplot2}
\title{tcplggplot2}
\usage{
tcplggplot2(
  dat,
  type = "mc",
  compare = "m4id",
  verbose = TRUE,
  flags = FALSE,
  yrange = c(NA, NA),
  group.fld = NULL,
  group.threshold = 9,
  hide_losing_models = FALSE
)
}
\arguments{
\item{dat}{data table with all required conc/resp data; each row will extend comparison}

\item{type}{string type of data that should be plotted
'sc' plotting - max medians plotted with hitcall
'mc' plotting - all fit models and winning model with hitcall}

\item{compare}{Character vector, the field(s) samples were joined on for comparison}

\item{verbose}{boolean should plotting include table of values next to the plot}

\item{flags}{boolean should plotting include level 6 flags in plot caption}

\item{yrange}{Integer of length 2, for overriding the y-axis range, c(<min>,<max>). 
By default, c(NA,NA).}

\item{group.fld}{Character, column name to group curves by when number of comparison 
curves exceeds group.threshold. By default 'modl' for MC and 'hitc' for SC.}

\item{group.threshold}{Integer of length 1, minimum number of samples in a 
given plot where comparison plots, instead of coloring models by sample, should
delineate curve color by a given group.fld. By default 9.}

\item{hide_losing_models}{Boolean, by default FALSE. For individual mc plots
only, should the losing models be hidden?}
}
\value{
A ggplot object or grob with accompanied table depending on verbose option
}
\description{
tcplggplot2
}
