% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poppk_mods.R
\name{pkmod_minto}
\alias{pkmod_minto}
\title{Minto population PK model for remifentanil}
\usage{
pkmod_minto(
  AGE,
  HGT = NULL,
  TBW = NULL,
  MALE = NULL,
  LBM = NULL,
  PD = TRUE,
  ...
)
}
\arguments{
\item{AGE}{Age (years)}

\item{HGT}{Height (cm). Used to calculate LBM if LBM is not provided.}

\item{TBW}{Weight (kg). Used to calculate LBM if LBM is not provided.}

\item{MALE}{Logical. Used to calculate LBM if LBM is not provided.}

\item{LBM}{Lean body mass (kg). Can be provided instead of TBW, HGT, and MALE}

\item{PD}{Logical. Should PD parameters be returned in addition to PK parameters.}

\item{...}{Arguments passed to `pkmod`}
}
\value{
`pkmod` object with Schnider population PK parameters
}
\description{
Evaluate Minto population PK model at patient covariate values.
Published in Minto et al. (1997). "Influence of Age and Gender on the
Pharmacokinetics and Pharmacodynamics of Remifentanil: I. Model Development."
Anesthesiology 86:10-23 doi: https://doi.org/10.1097/00000542-199701000-00004.
Residual error standard deviations are taken from Eleveld et al. (2017).
"An Allometric Model of Remifentanil Pharmacokinetics and Pharmacodynamics."
Anesthesiology Vol. 126, 1005–1018 doi: https://doi.org/10.1097/ALN.0000000000001634.
}
\examples{
pkmod_minto(AGE = 40,HGT=170,LBM = 43.9)
pkmod_minto(AGE = 40,HGT=170,TBW=50,MALE=TRUE)
}
