% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vc_test_perm.R
\name{vc_test_perm}
\alias{vc_test_perm}
\title{Permutation-based variance component test statistic}
\usage{
vc_test_perm(y, x, indiv = rep(1, nrow(x)), phi, w,
  Sigma_xi = diag(ncol(phi)), n_perm = 1000, genewise_pvals = FALSE,
  homogen_traj = FALSE, na.rm = FALSE)
}
\arguments{
\item{y}{a numeric matrix of dim \code{g x n} containing the raw RNA-seq counts for g
genes from \code{n} samples.}

\item{x}{a numeric design matrix of dim \code{n x p} containing the \code{p} covariates
to be adjusted for}

\item{indiv}{a vector of length \code{n} containing the information for
attributing each sample to one of the studied individuals. Coerced
to be a \code{factor}.}

\item{phi}{a numeric design matrix of size \code{n x K} containing the \code{K} variables
to be tested}

\item{w}{a vector of length \code{n} containing the weights for the \code{n}
samples.}

\item{Sigma_xi}{a matrix of size \code{K x K} containing the covariance matrix
of the \code{K} random effects.}

\item{n_perm}{the number of perturbations. Default is \code{1000}.}

\item{genewise_pvals}{a logical flag indicating whether gene-wise p-values should be returned. Default
is \code{FALSE} in which case gene-set p-value is computed and returned instead.}

\item{homogen_traj}{a logical flag indicating whether trajectories should be considered homogeneous.
Default is \code{FALSE} in which case trajectories are not only tested for trend, but also for heterogeneity.}

\item{na.rm}{logical: should missing values (including \code{NA} and \code{NaN})
be omitted from the calculations? Default is \code{FALSE}.}
}
\value{
A list with the following elements when the set p-value is computed :\itemize{
  \item \code{set_score_obs}: the approximation of the observed set score
  \item \code{set_pval}: the associated set p-value
}
or a list with the following elements when gene-wise p-values are computed:\itemize{
  \item \code{gene_scores_obs}: vector of approximating the observed gene-wise scores
  \item \code{gene_pvals}: vector of associated gene-wise p-values
  \item \code{ds_fdr}: vector of associated gene-wise discrete false discovery rates
}
}
\description{
This function computes an approximation of the Variance Component test for a
mixture of \eqn{\chi^{2}}s using permutations. This is preferable to the
asymptotic approximation for small sample sizes.
}
\examples{
#rm(list=ls())
set.seed(123)

##generate some fake data
########################
n <- 100
r <- 12
t <- matrix(rep(1:3), 4, ncol=1, nrow=r)
sigma <- 0.4
b0 <- 1

#under the null:
b1 <- 0
#under the alternative:
b1 <- 0.5
y.tilde <- b0 + b1*t + rnorm(r, sd = sigma)
y <- t(matrix(rnorm(n*r, sd = sqrt(sigma*abs(y.tilde))), ncol=n, nrow=r) +
      matrix(rep(y.tilde, n), ncol=n, nrow=r))
x <- matrix(1, ncol=1, nrow=r)

#run test
permTestRes <- vc_test_perm(y, x, phi=t, w=matrix(1, ncol=ncol(y), nrow=nrow(y)),
                           indiv=rep(1:4, each=3), n_perm=50) #1000)
permTestRes$set_pval

}
\seealso{
\code{\link[CompQuadForm]{davies}}
}
