% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner_hal.R
\name{learner_hal}
\alias{learner_hal}
\title{Construct a learner}
\usage{
learner_hal(
  formula,
  info = "hal9001::fit_hal",
  smoothness_orders = 0,
  reduce_basis = NULL,
  family = "gaussian",
  learner.args = NULL,
  ...
)
}
\arguments{
\item{formula}{(formula) Formula specifying response and design matrix.}

\item{info}{(character) Optional information to describe the instantiated
\link{learner} object.}

\item{smoothness_orders}{An \code{integer}, specifying the smoothness of the
basis functions. See details for \code{smoothness_orders} for more
information.}

\item{reduce_basis}{Am optional \code{numeric} value bounded in the open
unit interval indicating the minimum proportion of 1's in a basis function
column needed for the basis function to be included in the procedure to fit
the lasso. Any basis functions with a lower proportion of 1's than the
cutoff will be removed. Defaults to 1 over the square root of the number of
observations. Only applicable for models fit with zero-order splines, i.e.
\code{smoothness_orders = 0}.}

\item{family}{A \code{character} or a \code{\link[stats]{family}} object
(supported by \code{\link[glmnet]{glmnet}}) specifying the error/link
family for a generalized linear model. \code{character} options are limited
to "gaussian" for fitting a standard penalized linear model, "binomial" for
penalized logistic regression, "poisson" for penalized Poisson regression,
"cox" for a penalized proportional hazards model, and "mgaussian" for
multivariate penalized linear model. Note that passing in
family objects leads to slower performance relative to passing in a
character family (if supported). For example, one should set
\code{family = "binomial"} instead of \code{family = binomial()} when
calling \code{fit_hal}.}

\item{learner.args}{(list) Additional arguments to
\link[=learner]{learner$new()}.}

\item{...}{Additional arguments to \link[hal9001:fit_hal]{hal9001::fit_hal}.}
}
\value{
\link{learner} object.
}
\description{
Constructs a \link{learner} class object for fitting a highly
adaptive lasso model with \link[hal9001:fit_hal]{hal9001::fit_hal}.
}
\examples{
\dontrun{
n <- 5e2
x1 <- rnorm(n, sd = 2)
x2 <- rnorm(n)
y <- x1 + cos(x1) + rnorm(n, sd = 0.5**.5)
d <- data.frame(y, x1, x2)
lr <- learner_hal(y ~ x1 + x2, smoothness_orders = 0.5, reduce_basis = 1)
lr$estimate(d)
lr$predict(data.frame(x1 = 0, x2 = c(-1, 1)))
}
}
