% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_download.R
\name{tar_download_run}
\alias{tar_download_run}
\title{Download multiple URLs and return the local paths.}
\usage{
tar_download_run(urls, paths, method, quiet, mode, cacheOK, extra, headers)
}
\arguments{
\item{urls}{Character vector of URLs to track and download.
Must be known and declared before the pipeline runs.}

\item{paths}{Character vector of local file paths to
download each of the URLs.
Must be known and declared before the pipeline runs.}

\item{method}{Method to be used for downloading files.  Current
    download methods are \code{"internal"}, \code{"libcurl"},
    \code{"wget"}, \code{"curl"} and \code{"wininet"} (Windows
    only), and there is a value \code{"auto"}: see \sQuote{Details} and
    \sQuote{Note}.

    The method can also be set through the option
    \code{"download.file.method"}: see \code{\link{options}()}.
  }

\item{quiet}{If \code{TRUE}, suppress status messages (if any), and
    the progress bar.}

\item{mode}{character.  The mode with which to write the file.  Useful
    values are \code{"w"}, \code{"wb"} (binary), \code{"a"} (append) and
    \code{"ab"}.  Not used for methods \code{"wget"} and \code{"curl"}.
    See also \sQuote{Details}, notably about using \code{"wb"} for Windows.
  }

\item{cacheOK}{logical.  Is a server-side cached value acceptable?}

\item{extra}{character vector of additional command-line arguments for
    the \code{"wget"} and \code{"curl"} methods.}

\item{headers}{named character vector of HTTP headers to use in HTTP
    requests.  It is ignored for non-HTTP URLs.  The \code{User-Agent}
    header taken from the \code{HTTPUserAgent} option (see
    \code{\link{options}}) is automatically used as the first header.}
}
\value{
A character vector of file paths where the URLs
were downloaded.
}
\description{
Not a user-side function. Do not invoke directly.
}
\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
  tarchetypes::tar_download_run(
    urls = "https://httpbin.org/etag/test",
    paths = tempfile(),
    method = NULL,
    quiet = TRUE,
    mode = "w",
    cacheOK = NULL,
    extra = NULL,
    headers = NULL
  )
}
}
\keyword{internal}
