% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cloneMatrix}
\alias{cloneMatrix}
\title{Crates a deep copy of a matrix}
\usage{
cloneMatrix(M)
}
\arguments{
\item{M}{A matrix}
}
\value{
A deep copy of the matrix.
}
\description{
Useful  when calling \code{\link{ERE_step_cycle}} or
\code{\link{GibbsSteps_kcycle}} to ensure that
there are no side effects for the return values.
}
\examples{
lambda <- matrix(0.5,nrow=2,ncol=2)
p <- matrix(0.7, nrow=2,ncol=2)
L <- matrix(rexp(4),nrow=2);
L
Lold <- L
Lcopy <- cloneMatrix(L)
ERE_step_cycle(r=c(0,1),c=c(0,1),L=L,lambda=lambda,p=p)

L     ## new value
Lold  ## equal to L !!!
Lcopy ## still has the original value
}

