% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/Section4.R
\name{Section4}
\alias{Section4}
\alias{swe_fixstar2_mag}
\alias{swe_fixstar2}
\alias{swe_fixstar2_ut}
\title{Section 4: Fixed stars functions}
\usage{
swe_fixstar2_mag(starname)

swe_fixstar2(starname, jd_et, iflag)

swe_fixstar2_ut(starname, jd_ut, iflag)
}
\arguments{
\item{starname}{Star name as string ("" for no star)}

\item{jd_et}{ET Julian day number as double (day)}

\item{iflag}{Calculation flag as integer, many options possible (section 2.3)}

\item{jd_ut}{UT Julian day number (day)}
}
\value{
\code{swe_fixstar2_mag} returns a list with named entries: \code{return} status flag as integer,
        \code{starname} updated star name as string, \code{mag} magnitude of star as double, and \code{serr} for error message as string.

\code{swe_fixstar2} returns a list with named entries: \code{return} status flag as integer,
        \code{starname} updated star name as string, \code{xx} star phenomena as numeric vector, and \code{serr} error message as string.

\code{swe_fixstar2_ut} returns a list with named entries: \code{return} status flag as integer,
        \code{starname} updated star name as string, \code{xx} star information as numeric vector, and \code{serr} for error message as string.
}
\description{
The following functions are used to calculate positions of fixed stars.
}
\details{
\describe{
  \item{swe_fixstar2_mag()}{Calculate visible magnitude (Vmag) of star.} 
  \item{swe_fixstar2()}{Compute information of star using ET.}
  \item{swe_fixstar2_ut()}{Compute information of star using UT} 
}
}
\examples{
data(SE)
swe_fixstar2_mag("sirius") 
swe_set_topo(0,50,10)      
swe_fixstar2("sirius",1234567,SE$FLG_TOPOCTR+SE$FLG_MOSEPH+SE$FLG_EQUATORIAL)
swe_fixstar2_ut("sirius",1234567,SE$FLG_TOPOCTR+SE$FLG_MOSEPH+SE$FLG_EQUATORIAL)
}
\seealso{
\url{http://www.astro.com/swisseph/swephprg.htm#_Toc505244844}
}
