% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Install.R
\name{Install}
\alias{Install}
\title{An easy package installation function that pairs with \code{package()}}
\usage{
Install(pkgs = get_temp(".packages_to_install"), ..., ask = TRUE)
}
\arguments{
\item{pkgs}{The list of packages to install (character vector). If missing,
the list is read from \code{packages_to_install}, which is cleared on success.}

\item{...}{Further arguments passed to \code{\link[=install.packages]{install.packages()}}.}

\item{ask}{If \code{TRUE} and \code{pkgs} is missing, ask first to install the
packages.}
}
\value{
Returns \code{TRUE} in case of success, \code{FALSE} otherwise. The function is
invoked for its side-effect of installing \R packages.
}
\description{
This is similar to \code{\link[=install.packages]{install.packages()}}, except it takes by
default the list of packages from \code{.packages_to_install} in
\code{SciViews:TempEnv}. That list is populated automatically by unfructuous calls
to \code{package()}, so that just a call to \code{install()} without arguments is
generaly sufficient.
}
\seealso{
\code{\link[=package]{package()}}
}
\concept{
package installation
}
\keyword{utilities}
