% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcoxfunctional.R
\name{ggcoxfunctional}
\alias{ggcoxfunctional}
\alias{print.ggcoxfunctional}
\title{Functional Form of Continuous Variable in Cox Proportional Hazards Model}
\usage{
ggcoxfunctional(formula, data, iter = 0, f = 0.6, point.col = "red",
  point.size = 1, point.shape = 19, point.alpha = 1, font.main = c(16,
  "plain", "black"), font.x = c(14, "plain", "black"), font.y = c(14,
  "plain", "black"), font.tickslab = c(12, "plain", "black"), xlim = NULL,
  ylim = NULL, ylab = "Martingale Residuals \\nof Null Cox Model",
  ggtheme = theme_classic2())

\method{print}{ggcoxfunctional}(x, ...)
}
\arguments{
\item{formula}{a formula object, with the response on the left of a ~ operator, and the terms on the right. The response must be a survival object as returned by the \link{Surv} function.}

\item{data}{a \code{data.frame} in which to interpret the variables named in the formula,}

\item{iter}{parameter of \link{lowess}.}

\item{f}{parameter of \link{lowess}.}

\item{point.col, point.size, point.shape, point.alpha}{color, size, shape and visibility to be used for points.}

\item{font.main, font.x, font.y, font.tickslab}{a vector of length 3
indicating respectively the size (e.g.: 14), the style (e.g.: "plain",
"bold", "italic", "bold.italic") and the color (e.g.: "red") of main title,
xlab and ylab and axis tick labels, respectively. For example \emph{font.x =
c(14, "bold", "red")}.  Use font.x = 14, to change only font size; or use
font.x = "bold", to change only font face.}

\item{xlim, ylim}{x and y axis limits e.g. xlim = c(0, 1000), ylim = c(0, 1).}

\item{ylab}{y axis label.}

\item{ggtheme}{function, ggplot2 theme name. Default value is \link{theme_classic2}.
Allowed values include ggplot2 official themes: see \code{\link[ggplot2]{theme}}.}

\item{x}{an object of class ggcoxfunctional}

\item{...}{further arguments passed to print, but really it's unused}
}
\value{
Returns an object of class \code{ggcoxfunctional} which is a list of ggplots.
}
\description{
Displays graphs of continuous explanatory variable against martingale residuals of null
cox proportional hazards model, for each term in of the right side of \code{formula}. This might help to properly
choose the functional form of continuous variable in cox model (\link{coxph}). Fitted lines with \link{lowess} function
should be linear to satisfy cox proportional hazards model assumptions.
}
\section{Functions}{
\itemize{
\item \code{ggcoxfunctional}: Functional Form of Continuous Variable in Cox Proportional Hazards Model.
}}
\examples{

library(survival)
data(mgus)
ggcoxfunctional(Surv(futime, death) ~ mspike + log(mspike) + I(mspike^2) +
                  age + I(log(age)^2) + I(sqrt(age)), data = mgus,
                point.col = "blue", point.alpha = 0.5)


}
\author{
Marcin Kosinski , \email{m.p.kosinski@gmail.com}
}

