% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loghaz.R
\name{loghaz}
\alias{loghaz}
\title{Logistic-Hazard Survival Neural Network}
\usage{
loghaz(
  formula = NULL,
  data = NULL,
  reverse = FALSE,
  time_variable = "time",
  status_variable = "status",
  x = NULL,
  y = NULL,
  frac = 0,
  cuts = 10,
  cutpoints = NULL,
  scheme = c("equidistant", "quantiles"),
  cut_min = 0,
  activation = "relu",
  custom_net = NULL,
  num_nodes = c(32L, 32L),
  batch_norm = TRUE,
  dropout = NULL,
  device = NULL,
  early_stopping = FALSE,
  best_weights = FALSE,
  min_delta = 0,
  patience = 10L,
  batch_size = 256L,
  epochs = 1L,
  verbose = FALSE,
  num_workers = 0L,
  shuffle = TRUE,
  ...
)
}
\arguments{
\item{formula}{\code{(formula(1))}\cr
Object specifying the model fit, left-hand-side of formula should describe a \code{\link[survival:Surv]{survival::Surv()}}
object.}

\item{data}{\code{(data.frame(1))}\cr
Training data of \code{data.frame} like object, internally is coerced with \code{\link[stats:model.matrix]{stats::model.matrix()}}.}

\item{reverse}{\code{(logical(1))}\cr
If \code{TRUE} fits estimator on censoring distribution, otherwise (default) survival distribution.}

\item{time_variable}{\code{(character(1))}\cr
Alternative method to call the function. Name of the 'time' variable, required if \code{formula}.
or \code{x} and \code{Y} not given.}

\item{status_variable}{\code{(character(1))}\cr
Alternative method to call the function. Name of the 'status' variable, required if \code{formula}
or \code{x} and \code{Y} not given.}

\item{x}{\code{(data.frame(1))}\cr
Alternative method to call the function. Required if \verb{formula, time_variable} and
\code{status_variable} not given. Data frame like object of features which is internally
coerced with \code{model.matrix}.}

\item{y}{\verb{([survival::Surv()])}\cr
Alternative method to call the function. Required if \verb{formula, time_variable} and
\code{status_variable} not given. Survival outcome of right-censored observations.}

\item{frac}{\code{(numeric(1))} \cr
Fraction of data to use for validation dataset, default is \code{0} and therefore no separate
validation dataset.}

\item{cuts}{\code{(integer(1))}\cr
If \code{discretise} is \code{TRUE} then determines number of cut-points for discretisation.}

\item{cutpoints}{\code{(numeric())} \cr
Alternative to \code{cuts} if \code{discretise} is true, provide exact cutpoints for discretisation.
\code{cuts} is ignored if \code{cutpoints} is non-NULL.}

\item{scheme}{\code{(character(1))}\cr
Method of discretisation, either \code{"equidistant"} (default) or \code{"quantiles"}.
See \code{reticulate::py_help(pycox$models$LogisticHazard$label_transform)} for more detail.}

\item{cut_min}{\code{(integer(1))}\cr
Starting duration for discretisation, see
\code{reticulate::py_help(pycox$models$LogisticHazard$label_transform)} for more detail.}

\item{activation}{\code{(character(1))} \cr
See \link{get_pycox_activation}.}

\item{custom_net}{\code{(torch.nn.modules.module.Module(1))}\cr
Optional custom network built with \link{build_pytorch_net}, otherwise default architecture used.
Note that if building a custom network the number of output channels depends on \code{cuts} or
\code{cutpoints}.}

\item{num_nodes, batch_norm, dropout}{\code{(integer()/logical(1)/numeric(1))} \cr
See \link{build_pytorch_net}.}

\item{device}{\code{(integer(1)|character(1))}\cr
Passed to \code{pycox.models.LogisticHazard}, specifies device to compute models on.}

\item{early_stopping, best_weights, min_delta, patience}{\verb{(logical(1)/logical(1)/numeric(1)/integer(1)} \cr
See \link{get_pycox_callbacks}.}

\item{batch_size}{\code{(integer(1))}\cr
Passed to \code{pycox.models.LogisticHazard.fit}, elements in each batch.}

\item{epochs}{\code{(integer(1))}\cr
Passed to \code{pycox.models.LogisticHazard.fit}, number of epochs.}

\item{verbose}{\code{(logical(1))}\cr
Passed to \code{pycox.models.LogisticHazard.fit}, should information be displayed during
fitting.}

\item{num_workers}{\code{(integer(1))}\cr
Passed to \code{pycox.models.LogisticHazard.fit}, number of workers used in the
dataloader.}

\item{shuffle}{\code{(logical(1))}\cr
Passed to \code{pycox.models.LogisticHazard.fit}, should order of dataset be shuffled?}

\item{...}{\code{ANY} \cr
Passed to \link{get_pycox_optim}.}
}
\value{
An object inheriting from class \code{loghaz}.

An object of class \code{survivalmodel}.
}
\description{
Logistic-Hazard fits a discrete neural network based on a cross-entropy loss
and predictions of a discrete hazard function, also known as Nnet-Survival.
}
\details{
Implemented from the \code{pycox} Python package via \CRANpkg{reticulate}.
Calls \code{pycox.models.LogisticHazard}.
}
\examples{
\donttest{
if (requireNamespaces("reticulate")) {
  # all defaults
  loghaz(data = simsurvdata(50))

  # common parameters
  loghaz(data = simsurvdata(50), frac = 0.3, activation = "relu",
    num_nodes = c(4L, 8L, 4L, 2L), dropout = 0.1, early_stopping = TRUE, epochs = 100L,
    batch_size = 32L)
}
}

}
\references{
Gensheimer, M. F., & Narasimhan, B. (2018).
A Simple Discrete-Time Survival Model for Neural Networks, 1–17.
https://doi.org/arXiv:1805.00917v3

Kvamme, H., & Borgan, Ø. (2019).
Continuous and discrete-time survival prediction with neural networks.
https://doi.org/arXiv:1910.06724.
}
