% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_survey_scheme.R
\name{optimal_survey_scheme}
\alias{optimal_survey_scheme}
\title{Optimal survey scheme}
\usage{
optimal_survey_scheme(
  site_data,
  feature_data,
  site_detection_columns,
  site_n_surveys_columns,
  site_probability_columns,
  site_management_cost_column,
  site_survey_cost_column,
  feature_survey_column,
  feature_survey_sensitivity_column,
  feature_survey_specificity_column,
  feature_model_sensitivity_column,
  feature_model_specificity_column,
  feature_target_column,
  total_budget,
  survey_budget,
  site_management_locked_in_column = NULL,
  site_management_locked_out_column = NULL,
  site_survey_locked_out_column = NULL,
  prior_matrix = NULL,
  n_threads = 1,
  verbose = FALSE
)
}
\arguments{
\item{site_data}{\code{\link[sf:sf]{sf::sf()}} object with site data.}

\item{feature_data}{\code{\link[base:data.frame]{base::data.frame()}} object with feature data.}

\item{site_detection_columns}{\code{character} names of \code{numeric}
columns in the argument to \code{site_data} that contain the proportion of
surveys conducted within each site that detected each feature.
Each column should correspond to a different feature, and contain
a proportion value (between zero and one). If a site has
not previously been surveyed, a value of zero should be used.}

\item{site_n_surveys_columns}{\code{character} names of \code{numeric}
columns in the argument to \code{site_data} that contain the total
number of surveys conducted for each each feature within each site.
Each column should correspond to a different feature, and contain
a non-negative integer number (e.g. 0, 1, 2, 3). If a site has
not previously been surveyed, a value of zero should be used.}

\item{site_probability_columns}{\code{character} names of \code{numeric}
columns in the argument to \code{site_data} that contain modeled
probabilities of occupancy for each feature in each site.
Each column should correspond to a different feature, and contain
probability data (values between zero and one). No missing (\code{NA})
values are permitted in these columns.}

\item{site_management_cost_column}{\code{character} name of column in the
argument to \code{site_data} that contains costs for managing each
site for conservation. This column should have \code{numeric} values that
are equal to or greater than zero. No missing (\code{NA}) values are
permitted in this column.}

\item{site_survey_cost_column}{\code{character} name of column in the
argument to  \code{site_data} that contains costs for surveying each
site. This column should have \code{numeric} values that are equal to
or greater than zero. No missing (\code{NA}) values are permitted in this
column.}

\item{feature_survey_column}{\code{character} name of the column in the
argument to \code{feature_data} that contains \code{logical} (\code{TRUE} /
\code{FALSE}) values indicating if the feature will be surveyed in
the planned surveys or not. Note that considering additional features will
rapidly increase computational burden, and so it is only recommended to
consider features that are of specific conservation interest.
No missing (\code{NA}) values are permitted in this column.}

\item{feature_survey_sensitivity_column}{\code{character} name of the
column in the argument to \code{feature_data} that contains
probability of future surveys correctly detecting a presence of each
feature in a given site (i.e. the sensitivity of the survey methodology).
This column should have \code{numeric} values that are between zero and
one. No missing (\code{NA}) values are permitted in this column.}

\item{feature_survey_specificity_column}{\code{character} name of the
column in the argument to \code{feature_data} that contains
probability of future surveys correctly detecting an absence of each
feature in a given site (i.e. the specificity of the survey methodology).
This column should have \code{numeric} values that are between zero and
one. No missing (\code{NA}) values are permitted in this column.}

\item{feature_model_sensitivity_column}{\code{character} name of the
column in the argument to \code{feature_data} that contains
probability of the initial models correctly predicting a presence of each
feature in a given site (i.e. the sensitivity of the models).
This column should have \code{numeric} values that are between zero and
one. No missing (\code{NA}) values are permitted in this column.
This should ideally be calculated using
\code{\link[=fit_xgb_occupancy_models]{fit_xgb_occupancy_models()}} or
\code{\link[=fit_hglm_occupancy_models]{fit_hglm_occupancy_models()}}.}

\item{feature_model_specificity_column}{\code{character} name of the
column in the argument to \code{feature_data} that contains
probability of the initial models correctly predicting an absence of each
feature in a given site (i.e. the specificity of the models).
This column should have \code{numeric} values that are between zero and
one. No missing (\code{NA}) values are permitted in this column.
This should ideally be calculated using
\code{\link[=fit_xgb_occupancy_models]{fit_xgb_occupancy_models()}} or
\code{\link[=fit_hglm_occupancy_models]{fit_hglm_occupancy_models()}}.}

\item{feature_target_column}{\code{character} name of the column in the
argument to \code{feature_data} that contains the \eqn{target}
values used to parametrize the conservation benefit of managing of each
feature.
This column should have \code{numeric} values that
are equal to or greater than zero. No missing (\code{NA}) values are
permitted in this column.}

\item{total_budget}{\code{numeric} maximum expenditure permitted
for conducting surveys and managing sites for conservation.}

\item{survey_budget}{\code{numeric} maximum expenditure permitted
for conducting surveys.}

\item{site_management_locked_in_column}{\code{character} name of the column
in the argument to \code{site_data} that contains \code{logical}
(\code{TRUE} / \code{FALSE}) values indicating which sites should
be locked in for (\code{TRUE}) being managed for conservation or
(\code{FALSE}) not. No missing (\code{NA}) values are permitted in this
column. This is useful if some sites have already been earmarked for
conservation, or if some sites are already being managed for conservation.
Defaults to \code{NULL} such that no sites are locked in.}

\item{site_management_locked_out_column}{\code{character} name of the column
in the argument to \code{site_data} that contains \code{logical}
(\code{TRUE} / \code{FALSE}) values indicating which sites should
be locked out for (\code{TRUE}) being managed for conservation or
(\code{FALSE}) not. No missing (\code{NA}) values are permitted in this
column. This is useful if some sites could potentially be surveyed
to improve model predictions even if they cannot be managed for
conservation. Defaults to \code{NULL} such that no sites are locked out.}

\item{site_survey_locked_out_column}{\code{character} name of the column
in the argument to \code{site_data} that contains \code{logical}
(\code{TRUE} / \code{FALSE}) values indicating which sites should
be locked out (\code{TRUE}) from being selected for future surveys or
(\code{FALSE}) not. No missing (\code{NA}) values are permitted in this
column. This is useful if some sites will never be considered for future
surveys (e.g. because they are too costly to survey, or have a
low chance of containing the target species).
Defaults to \code{NULL} such that no sites are locked out.}

\item{prior_matrix}{\code{numeric} \code{matrix} containing
the prior probability of each feature occupying each site.
Rows correspond to features, and columns correspond to sites.
Defaults to \code{NULL} such that prior data is calculated automatically
using \code{\link[=prior_probability_matrix]{prior_probability_matrix()}}.}

\item{n_threads}{\code{integer} number of threads to use for computation.}

\item{verbose}{\code{logical} indicating if information should be
printed during processing. Defaults to \code{FALSE}.}
}
\value{
A \code{matrix} of \code{logical} (\code{TRUE}/ \code{FALSE})
values indicating if a site is selected in the scheme or not. Columns
correspond to sites, and rows correspond to different schemes. If
there is only one optimal survey scheme then the \code{matrix} will only
contain a single row. This matrix also has a \code{numeric} \code{"ev"}
attribute that contains the expected value of each scheme.
}
\description{
Find the optimal survey scheme that maximizes value of information.
This function uses the exact method for
calculating the expected value of the decision given a survey scheme.
}
\details{
The optimal survey scheme is determined using a brute-force algorithm.
Initially, all feasible (valid) survey schemes are identified given the
survey costs and the survey budget (using
\code{\link[=feasible_survey_schemes]{feasible_survey_schemes()}}. Next, the expected value of each and
every feasible survey scheme is computed
(using \code{\link[=evdsi]{evdsi()}}).
Finally, the greatest expected value is identified, and all survey schemes
that share this greatest expected value are returned. Due to the nature of
this algorithm, it can take a very long time to complete.
}
\section{Dependencies}{

Please note that this function requires the Gurobi optimization software
(\url{https://www.gurobi.com/}) and the \pkg{gurobi} R package if different
sites have different survey costs. Installation instruction are available
online for for \href{https://www.gurobi.com/documentation/9.1/quickstart_linux/r_ins_the_r_package.html}{Linux}, \href{https://www.gurobi.com/documentation/9.1/quickstart_windows/r_ins_the_r_package.html}{Windows}, and \href{https://www.gurobi.com/documentation/9.1/quickstart_mac/r_ins_the_r_package.html}{Mac OS}.
}

\examples{
# set seeds for reproducibility
set.seed(123)

# load example site data
data(sim_sites)
print(sim_sites)

# load example feature data
data(sim_features)
print(sim_features)

# set total budget for managing sites for conservation
# (i.e. 50\% of the cost of managing all sites)
total_budget <- sum(sim_sites$management_cost) * 0.5

# set total budget for surveying sites for conservation
# (i.e. 40\% of the cost of managing all sites)
survey_budget <- sum(sim_sites$survey_cost) * 0.4

\dontrun{
# find optimal survey scheme using exact method
opt_survey <- optimal_survey_scheme(
  sim_sites, sim_features,
  c("f1", "f2", "f3"), c("n1", "n2", "n3"), c("p1", "p2", "p3"),
  "management_cost", "survey_cost",
  "survey", "survey_sensitivity", "survey_specificity",
  "model_sensitivity", "model_specificity",
  "target", total_budget, survey_budget)

# print result
print(opt_survey)
}
}
