/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.generators;

import com.github.javacliparser.FlagOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import java.util.ArrayList;
import java.util.Random;
import moa.core.InstanceExample;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.streams.InstanceStream;
import moa.tasks.TaskMonitor;

public class SineGenerator
extends AbstractOptionHandler
implements InstanceStream {
    public static final int NUM_IRRELEVANT_ATTRIBUTES = 2;
    public IntOption instanceRandomSeedOption = new IntOption("instanceRandomSeed", 'i', "Seed for random generation of instances.", 1);
    public IntOption functionOption = new IntOption("function", 'f', "Classification function used, as defined in the original paper.", 1, 1, 4);
    public FlagOption suppressIrrelevantAttributesOption = new FlagOption("suppressIrrelevantAttributes", 's', "Reduce the data to only contain 2 relevant numeric attributes.");
    public FlagOption balanceClassesOption = new FlagOption("balanceClasses", 'b', "Balance the number of instances of each class.");
    protected InstancesHeader streamHeader;
    protected Random instanceRandom;
    protected boolean nextClassShouldBeZero;
    protected static ClassFunction[] classificationFunctions = new ClassFunction[]{new ClassFunction(){

        @Override
        public int determineClass(double x, double y) {
            return y < Math.sin(x) ? 0 : 1;
        }
    }, new ClassFunction(){

        @Override
        public int determineClass(double x, double y) {
            return y >= Math.sin(x) ? 0 : 1;
        }
    }, new ClassFunction(){

        @Override
        public int determineClass(double x, double y) {
            return y < 0.5 + 0.3 * Math.sin(Math.PI * 3 * x) ? 0 : 1;
        }
    }, new ClassFunction(){

        @Override
        public int determineClass(double x, double y) {
            return y >= 0.5 + 0.3 * Math.sin(Math.PI * 3 * x) ? 0 : 1;
        }
    }};

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    public InstancesHeader getHeader() {
        return this.streamHeader;
    }

    @Override
    public long estimatedRemainingInstances() {
        return -1L;
    }

    @Override
    public boolean hasMoreInstances() {
        return true;
    }

    @Override
    public InstanceExample nextInstance() {
        double a1 = 0.0;
        double a2 = 0.0;
        double group = 0.0;
        boolean desiredClassFound = false;
        while (!desiredClassFound) {
            a1 = this.instanceRandom.nextDouble();
            a2 = this.instanceRandom.nextDouble();
            group = classificationFunctions[this.functionOption.getValue() - 1].determineClass(a1, a2);
            if (!this.balanceClassesOption.isSet()) {
                desiredClassFound = true;
                continue;
            }
            if ((!this.nextClassShouldBeZero || group != 0.0) && (this.nextClassShouldBeZero || group != 1.0)) continue;
            desiredClassFound = true;
            this.nextClassShouldBeZero = !this.nextClassShouldBeZero;
        }
        InstancesHeader header = this.getHeader();
        DenseInstance inst = new DenseInstance((double)header.numAttributes());
        inst.setValue(0, a1);
        inst.setValue(1, a2);
        inst.setDataset(header);
        if (!this.suppressIrrelevantAttributesOption.isSet()) {
            for (int i = 0; i < 2; ++i) {
                inst.setValue(i + 2, this.instanceRandom.nextDouble());
            }
        }
        inst.setClassValue(group);
        return new InstanceExample(inst);
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    @Override
    public void restart() {
        this.instanceRandom = new Random(this.instanceRandomSeedOption.getValue());
        this.nextClassShouldBeZero = false;
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        int numAtts = 2;
        if (!this.suppressIrrelevantAttributesOption.isSet()) {
            numAtts += 2;
        }
        for (int i = 0; i < numAtts; ++i) {
            attributes.add(new Attribute("att" + (i + 1)));
        }
        ArrayList<String> classLabels = new ArrayList<String>();
        classLabels.add("positive");
        classLabels.add("negative");
        Attribute classAtt = new Attribute("class", classLabels);
        attributes.add(classAtt);
        this.streamHeader = new InstancesHeader(new Instances(this.getCLICreationString(InstanceStream.class), attributes, 0));
        this.streamHeader.setClassIndex(this.streamHeader.numAttributes() - 1);
        this.restart();
    }

    protected static interface ClassFunction {
        public int determineClass(double var1, double var3);
    }
}

