/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.generators;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import java.util.Arrays;
import java.util.Random;
import moa.core.FastVector;
import moa.core.InstanceExample;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.streams.InstanceStream;
import moa.tasks.TaskMonitor;

public class AssetNegotiationGenerator
extends AbstractOptionHandler
implements InstanceStream {
    public IntOption functionOption = new IntOption("function", 'f', "Classification function used, as defined in the original paper.", 1, 1, 5);
    public FloatOption noisePercentage = new FloatOption("noise", 'n', "% of class noise.", 0.05, 0.0, 1.0);
    public IntOption instanceRandomSeedOption = new IntOption("instanceRandomSeed", 'i', "Seed for random generation of instances.", 1);
    protected InstancesHeader streamHeader;
    protected Random instanceRandom;
    protected boolean nextClassShouldBeZero;
    protected ClassFunction classFunction;
    protected static String[] colorValues = new String[]{"black", "blue", "cyan", "brown", "red", "green", "yellow", "magenta"};
    protected static String[] priceValues = new String[]{"veryLow", "low", "normal", "high", "veryHigh", "quiteHigh", "enormous", "non_salable"};
    protected static String[] paymentValues = new String[]{"0", "30", "60", "90", "120", "150", "180", "210", "240"};
    protected static String[] amountValues = new String[]{"veryLow", "low", "normal", "high", "veryHigh", "quiteHigh", "enormous", "non_ensured"};
    protected static String[] deliveryDelayValues = new String[]{"veryLow", "low", "normal", "high", "veryHigh"};
    protected static String[] classValues = new String[]{"interested", "notInterested"};
    protected static ClassFunction[] concepts = new ClassFunction[]{new ClassFunction(){
        Random r = new Random(Integer.MAX_VALUE);

        @Override
        public int determineClass(String color, String price, String payment, String amount, String deliveryDelay) {
            if (price.equals("normal") && amount.equals("high") || color.equals("brown") && price.equals("veryLow") && deliveryDelay.equals("high")) {
                return AssetNegotiationGenerator.indexOfValue("interested", classValues);
            }
            return AssetNegotiationGenerator.indexOfValue("notInterested", classValues);
        }

        @Override
        public Instance makeTrue(Instance intnc) {
            int part = this.r.nextInt(2);
            if (part == 0) {
                intnc.setValue(1, (double)AssetNegotiationGenerator.indexOfValue("normal", priceValues));
                intnc.setValue(3, (double)AssetNegotiationGenerator.indexOfValue("high", amountValues));
            } else {
                intnc.setValue(0, (double)AssetNegotiationGenerator.indexOfValue("brown", colorValues));
                intnc.setValue(1, (double)AssetNegotiationGenerator.indexOfValue("veryLow", priceValues));
                intnc.setValue(4, (double)AssetNegotiationGenerator.indexOfValue("high", deliveryDelayValues));
            }
            intnc.setClassValue(AssetNegotiationGenerator.indexOfValue("interested", classValues));
            return intnc;
        }
    }, new ClassFunction(){
        Random r = new Random(Integer.MAX_VALUE);

        @Override
        public int determineClass(String color, String price, String payment, String amount, String deliveryDelay) {
            if (price.equals("high") && amount.equals("veryHigh") && deliveryDelay.equals("high")) {
                return AssetNegotiationGenerator.indexOfValue("interested", classValues);
            }
            return AssetNegotiationGenerator.indexOfValue("notInterested", classValues);
        }

        @Override
        public Instance makeTrue(Instance intnc) {
            intnc.setValue(1, (double)AssetNegotiationGenerator.indexOfValue("high", priceValues));
            intnc.setValue(3, (double)AssetNegotiationGenerator.indexOfValue("veryHigh", amountValues));
            intnc.setValue(4, (double)AssetNegotiationGenerator.indexOfValue("high", deliveryDelayValues));
            intnc.setClassValue(Arrays.asList(classValues).indexOf("interested"));
            return intnc;
        }
    }, new ClassFunction(){
        Random r = new Random(Integer.MAX_VALUE);

        @Override
        public int determineClass(String color, String price, String payment, String amount, String deliveryDelay) {
            if (price.equals("veryLow") && payment.equals("0") && amount.equals("high") || color.equals("red") && price.equals("low") && payment.equals("30")) {
                return AssetNegotiationGenerator.indexOfValue("interested", classValues);
            }
            return AssetNegotiationGenerator.indexOfValue("notInterested", classValues);
        }

        @Override
        public Instance makeTrue(Instance intnc) {
            int part = this.r.nextInt(2);
            if (part == 0) {
                intnc.setValue(1, (double)AssetNegotiationGenerator.indexOfValue("veryLow", priceValues));
                intnc.setValue(2, (double)AssetNegotiationGenerator.indexOfValue("0", paymentValues));
                intnc.setValue(3, (double)AssetNegotiationGenerator.indexOfValue("high", amountValues));
            } else {
                intnc.setValue(0, (double)AssetNegotiationGenerator.indexOfValue("red", colorValues));
                intnc.setValue(1, (double)AssetNegotiationGenerator.indexOfValue("low", priceValues));
                intnc.setValue(2, (double)AssetNegotiationGenerator.indexOfValue("30", paymentValues));
            }
            intnc.setClassValue(Arrays.asList(classValues).indexOf("interested"));
            return intnc;
        }
    }, new ClassFunction(){
        Random r = new Random(Integer.MAX_VALUE);

        @Override
        public int determineClass(String color, String price, String payment, String amount, String deliveryDelay) {
            if (color.equals("black") && payment.equals("90") && deliveryDelay.equals("veryLow") || color.equals("magenta") && price.equals("high") && deliveryDelay.equals("veryLow")) {
                return AssetNegotiationGenerator.indexOfValue("interested", classValues);
            }
            return AssetNegotiationGenerator.indexOfValue("notInterested", classValues);
        }

        @Override
        public Instance makeTrue(Instance intnc) {
            int part = this.r.nextInt(2);
            if (part == 0) {
                intnc.setValue(0, (double)AssetNegotiationGenerator.indexOfValue("black", colorValues));
                intnc.setValue(2, (double)AssetNegotiationGenerator.indexOfValue("90", paymentValues));
                intnc.setValue(4, (double)AssetNegotiationGenerator.indexOfValue("veryLow", deliveryDelayValues));
            } else {
                intnc.setValue(0, (double)AssetNegotiationGenerator.indexOfValue("magenta", colorValues));
                intnc.setValue(1, (double)AssetNegotiationGenerator.indexOfValue("high", priceValues));
                intnc.setValue(4, (double)AssetNegotiationGenerator.indexOfValue("veryLow", deliveryDelayValues));
            }
            intnc.setClassValue(Arrays.asList(classValues).indexOf("interested"));
            return intnc;
        }
    }, new ClassFunction(){
        Random r = new Random(Integer.MAX_VALUE);

        @Override
        public int determineClass(String color, String price, String payment, String amount, String deliveryDelay) {
            if (color.equals("blue") && payment.equals("60") && amount.equals("low") && deliveryDelay.equals("normal") || color.equals("cyan") && amount.equals("low") && deliveryDelay.equals("normal")) {
                return AssetNegotiationGenerator.indexOfValue("interested", classValues);
            }
            return AssetNegotiationGenerator.indexOfValue("notInterested", classValues);
        }

        @Override
        public Instance makeTrue(Instance intnc) {
            int part = this.r.nextInt(2);
            if (part == 0) {
                intnc.setValue(0, (double)AssetNegotiationGenerator.indexOfValue("blue", colorValues));
                intnc.setValue(2, (double)AssetNegotiationGenerator.indexOfValue("60", paymentValues));
                intnc.setValue(3, (double)AssetNegotiationGenerator.indexOfValue("low", amountValues));
                intnc.setValue(4, (double)AssetNegotiationGenerator.indexOfValue("normal", deliveryDelayValues));
            } else {
                intnc.setValue(0, (double)AssetNegotiationGenerator.indexOfValue("cyan", colorValues));
                intnc.setValue(3, (double)AssetNegotiationGenerator.indexOfValue("low", amountValues));
                intnc.setValue(4, (double)AssetNegotiationGenerator.indexOfValue("normal", deliveryDelayValues));
            }
            intnc.setClassValue(Arrays.asList(classValues).indexOf("interested"));
            return intnc;
        }
    }};

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        sb.append("Generates instances based on 5 different concept functions that describe whether another agent is interested or not in an item.");
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor tm, ObjectRepository or) {
        this.classFunction = concepts[this.functionOption.getValue() - 1];
        FastVector<Attribute> attributes = new FastVector<Attribute>();
        attributes.addElement(new Attribute("color", Arrays.asList(colorValues)));
        attributes.addElement(new Attribute("price", Arrays.asList(priceValues)));
        attributes.addElement(new Attribute("payment", Arrays.asList(paymentValues)));
        attributes.addElement(new Attribute("amount", Arrays.asList(amountValues)));
        attributes.addElement(new Attribute("deliveryDelay", Arrays.asList(deliveryDelayValues)));
        this.instanceRandom = new Random(System.currentTimeMillis());
        FastVector<String> classLabels = new FastVector<String>();
        for (int i = 0; i < classValues.length; ++i) {
            classLabels.addElement(classValues[i]);
        }
        attributes.addElement(new Attribute("class", classLabels));
        this.streamHeader = new InstancesHeader(new Instances(this.getCLICreationString(InstanceStream.class), attributes, 0));
        this.streamHeader.setClassIndex(this.streamHeader.numAttributes() - 1);
        this.restart();
    }

    @Override
    public InstancesHeader getHeader() {
        return this.streamHeader;
    }

    @Override
    public long estimatedRemainingInstances() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean hasMoreInstances() {
        return true;
    }

    @Override
    public InstanceExample nextInstance() {
        Instance instnc = null;
        boolean classFound = false;
        while (!classFound) {
            int indexColor = this.instanceRandom.nextInt(colorValues.length);
            int indexPrice = this.instanceRandom.nextInt(priceValues.length);
            int indexPayment = this.instanceRandom.nextInt(paymentValues.length);
            int indexAmount = this.instanceRandom.nextInt(amountValues.length);
            int indexDelivery = this.instanceRandom.nextInt(deliveryDelayValues.length);
            String color = colorValues[indexColor];
            String price = priceValues[indexPrice];
            String payment = paymentValues[indexPayment];
            String amount = amountValues[indexAmount];
            String delivery = deliveryDelayValues[indexDelivery];
            int classValue = this.classFunction.determineClass(color, price, payment, amount, delivery);
            instnc = new DenseInstance((double)this.streamHeader.numAttributes());
            instnc.setDataset(this.getHeader());
            instnc.setValue(0, (double)Arrays.asList(colorValues).indexOf(color));
            instnc.setValue(1, (double)Arrays.asList(priceValues).indexOf(price));
            instnc.setValue(2, (double)Arrays.asList(paymentValues).indexOf(payment));
            instnc.setValue(3, (double)Arrays.asList(amountValues).indexOf(amount));
            instnc.setValue(4, (double)Arrays.asList(deliveryDelayValues).indexOf(delivery));
            if (classValue == 0 && !this.nextClassShouldBeZero) {
                instnc = this.classFunction.makeTrue(instnc);
                classValue = 1;
                this.nextClassShouldBeZero = !this.nextClassShouldBeZero;
                classFound = true;
            } else if (classValue == 0 && this.nextClassShouldBeZero) {
                this.nextClassShouldBeZero = !this.nextClassShouldBeZero;
                classFound = true;
            } else if (classValue == 1 && !this.nextClassShouldBeZero) {
                this.nextClassShouldBeZero = !this.nextClassShouldBeZero;
                classFound = true;
            }
            instnc.setClassValue(classValue);
        }
        int newClassValue = this.addNoise((int)instnc.classValue());
        instnc.setClassValue(newClassValue);
        return new InstanceExample(instnc);
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    @Override
    public void restart() {
        this.instanceRandom = new Random(this.instanceRandomSeedOption.getValue());
        this.nextClassShouldBeZero = false;
    }

    int addNoise(int classObtained) {
        if ((double)this.instanceRandom.nextFloat() <= this.noisePercentage.getValue()) {
            classObtained = classObtained == 0 ? 1 : 0;
        }
        return classObtained;
    }

    private static int indexOfValue(String value, Object[] arr) {
        int index = Arrays.asList(arr).indexOf(value);
        return index;
    }

    protected static interface ClassFunction {
        public int determineClass(String var1, String var2, String var3, String var4, String var5);

        public Instance makeTrue(Instance var1);
    }
}

