/*
 * Decompiled with CFR 0.152.
 */
package moa.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import moa.evaluation.preview.Preview;

public class PreviewTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    List<String> names = new ArrayList<String>();
    List<double[]> data = new ArrayList<double[]>();
    Preview latestPreview = null;
    boolean structureChangeFlag = false;

    @Override
    public String getColumnName(int column) {
        return this.names.get(column);
    }

    @Override
    public int getColumnCount() {
        return this.names.size();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row >= this.data.size() || column >= this.data.get(row).length) {
            return 0.0;
        }
        return this.data.get(row)[column];
    }

    public void setPreview(Preview preview) {
        this.structureChangeFlag = false;
        if (preview == null) {
            if (this.latestPreview != null) {
                this.names = new ArrayList<String>();
                this.data = new ArrayList<double[]>();
                this.structureChangeFlag = true;
            }
        } else {
            this.structureChangeFlag |= this.latestPreview == null;
            this.structureChangeFlag |= this.latestPreview != null && this.latestPreview.numEntries() == 0 && preview.numEntries() > 0;
            this.structureChangeFlag |= this.latestPreview != null && this.latestPreview.getTaskClass() != preview.getTaskClass();
        }
        this.latestPreview = preview;
        if (preview != null) {
            this.data = preview.getData();
            if (this.structureChangeFlag) {
                this.copyMeasurementNames(preview);
            }
        }
    }

    public String toString() {
        return this.latestPreview == null ? "" : this.latestPreview.toString();
    }

    public boolean structureChanged() {
        return this.structureChangeFlag;
    }

    private void copyMeasurementNames(Preview preview) {
        this.names = new ArrayList<String>();
        int newMeasurementNameCount = preview.getMeasurementNameCount();
        for (int measurementNameIdx = 0; measurementNameIdx < newMeasurementNameCount; ++measurementNameIdx) {
            this.names.add(preview.getMeasurementName(measurementNameIdx));
        }
    }
}

