/*
 * Decompiled with CFR 0.152.
 */
package moa.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class FixedLengthList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 5763493643390042080L;
    private int maxSize;

    public FixedLengthList(int m) {
        this.maxSize = m;
    }

    @Override
    public boolean add(E entry) {
        super.add(entry);
        if (this.size() > this.maxSize) {
            super.removeRange(0, this.size() - this.maxSize);
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Iterator<E> cIterator = c.iterator();
        while (cIterator.hasNext()) {
            this.add(cIterator.next());
        }
        return true;
    }

    public E getOldestEntry() {
        return super.get(0);
    }

    public E getYoungestEntry() {
        return super.get(this.size() - 1);
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

