/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.outliers.SimpleCOD;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import moa.clusterers.outliers.MyBaseOutlierDetector;
import moa.clusterers.outliers.SimpleCOD.ISBIndex;

public abstract class SimpleCODBase
extends MyBaseOutlierDetector {
    protected static final Long FIRST_OBJ_ID = 1L;
    protected Long objId;
    protected Vector<ISBIndex.ISBNode> windowNodes;
    protected EventQueue eventQueue;
    protected ISBIndex ISB;
    protected int m_WindowSize;
    protected double m_radius;
    protected int m_k;
    public boolean bWarning = false;
    public int m_nBothInlierOutlier;
    public int m_nOnlyInlier;
    public int m_nOnlyOutlier;

    @Override
    public String getObjectInfo(Object obj) {
        int i;
        if (obj == null) {
            return null;
        }
        ISBIndex.ISBNode node = (ISBIndex.ISBNode)obj;
        ArrayList<String> infoTitle = new ArrayList<String>();
        ArrayList<String> infoValue = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < node.obj.dimensions(); ++i) {
            infoTitle.add("Dim" + (i + 1));
            infoValue.add(String.format("%.3f", node.obj.get(i)));
        }
        infoTitle.add("id");
        infoValue.add(String.format("%d", node.id));
        infoTitle.add("count_after");
        infoValue.add(String.format("%d", node.count_after));
        infoTitle.add("|nn_before|");
        infoValue.add(String.format("%d", node.CountPrecNeighs(this.GetWindowStart())));
        sb.append("<html>");
        sb.append("<table>");
        for (i = 0; i < infoTitle.size() && i < infoValue.size(); ++i) {
            sb.append("<tr><td><b>" + (String)infoTitle.get(i) + ":</b></td><td>" + (String)infoValue.get(i) + "</td></tr>");
        }
        sb.append("</table>");
        sb.append("</html>");
        return sb.toString();
    }

    @Override
    public String getStatistics() {
        StringBuilder sb = new StringBuilder();
        sb.append("Statistics:\n\n");
        int nBothInlierOutlier = this.m_nBothInlierOutlier;
        int nOnlyInlier = this.m_nOnlyInlier;
        int nOnlyOutlier = this.m_nOnlyOutlier;
        for (ISBIndex.ISBNode node : this.windowNodes) {
            if (node.nInlier > 0 && node.nOutlier > 0) {
                ++nBothInlierOutlier;
                continue;
            }
            if (node.nInlier > 0) {
                ++nOnlyInlier;
                continue;
            }
            ++nOnlyOutlier;
        }
        int sum = nBothInlierOutlier + nOnlyInlier + nOnlyOutlier;
        if (sum > 0) {
            sb.append(String.format("  Nodes always inlier: %d (%.1f%%)\n", nOnlyInlier, (double)(100 * nOnlyInlier) / (double)sum));
            sb.append(String.format("  Nodes always outlier: %d (%.1f%%)\n", nOnlyOutlier, (double)(100 * nOnlyOutlier) / (double)sum));
            sb.append(String.format("  Nodes both inlier and outlier: %d (%.1f%%)\n", nBothInlierOutlier, (double)(100 * nBothInlierOutlier) / (double)sum));
            sb.append("  (Sum: " + sum + ")\n");
        }
        sb.append("\n  Total range queries: " + this.nRangeQueriesExecuted + "\n");
        sb.append("  Max memory usage: " + this.iMaxMemUsage + " MB\n");
        sb.append("  Total process time: " + String.format("%.2f ms", (double)this.nTotalRunTime.longValue() / 1000.0) + "\n");
        return sb.toString();
    }

    Long GetWindowEnd() {
        return this.objId - 1L;
    }

    Long GetWindowStart() {
        Long x = this.GetWindowEnd() - (long)this.m_WindowSize + 1L;
        if (x < FIRST_OBJ_ID) {
            x = FIRST_OBJ_ID;
        }
        return x;
    }

    boolean IsWinFull() {
        return this.GetWindowEnd() >= FIRST_OBJ_ID + (long)this.m_WindowSize - 1L;
    }

    Long GetExpirationTime(ISBIndex.ISBNode node) {
        return node.id + (long)this.m_WindowSize;
    }

    void SaveOutlier(ISBIndex.ISBNode node) {
        this.AddOutlier(new MyBaseOutlierDetector.Outlier(node.inst, node.id, node));
        ++node.nOutlier;
    }

    void RemoveOutlier(ISBIndex.ISBNode node) {
        this.RemoveOutlier(new MyBaseOutlierDetector.Outlier(node.inst, node.id, node));
        ++node.nInlier;
    }

    @Override
    protected boolean IsNodeIdInWin(long id) {
        int toleranceStart = 1;
        Long start = this.GetWindowStart() - (long)toleranceStart;
        return start <= id && id <= this.GetWindowEnd();
    }

    void AddNode(ISBIndex.ISBNode node) {
        this.windowNodes.add(node);
    }

    void RemoveNode(ISBIndex.ISBNode node) {
        this.windowNodes.remove(node);
        this.RemoveExpiredOutlier(new MyBaseOutlierDetector.Outlier(node.inst, node.id, node));
        this.UpdateStatistics(node);
    }

    void UpdateStatistics(ISBIndex.ISBNode node) {
        if (node.nInlier > 0 && node.nOutlier > 0) {
            ++this.m_nBothInlierOutlier;
        } else if (node.nInlier > 0) {
            ++this.m_nOnlyInlier;
        } else {
            ++this.m_nOnlyOutlier;
        }
    }

    ISBIndex.ISBNode GetExpiredNode() {
        if (this.windowNodes.size() <= 0) {
            return null;
        }
        ISBIndex.ISBNode node = this.windowNodes.get(0);
        if (node.id < this.GetWindowStart()) {
            return node;
        }
        return null;
    }

    double GetEuclideanDist(ISBIndex.ISBNode n1, ISBIndex.ISBNode n2) {
        double sum = 0.0;
        int d = n1.obj.dimensions();
        for (int i = 0; i < d; ++i) {
            double diff = n1.obj.get(i) - n2.obj.get(i);
            sum += Math.pow(diff, 2.0);
        }
        return Math.sqrt(sum);
    }

    void PrintWindow() {
        this.Println("Window [" + this.GetWindowStart() + "-" + this.GetWindowEnd() + "]: ");
        for (int i = 0; i < this.windowNodes.size(); ++i) {
            ISBIndex.ISBNode node = this.windowNodes.get(i);
            this.Print("   Node: ");
            this.PrintNode(node);
        }
    }

    void PrintNode(ISBIndex.ISBNode n) {
        this.Print("id=" + n.id + " (");
        int dim = n.obj.dimensions();
        for (int d = 0; d < dim; ++d) {
            this.Print(Double.toString(n.obj.get(d)));
            if (d >= dim - 1) continue;
            this.Print(", ");
        }
        this.Println(")");
    }

    public void PrintNodeSet(Set<ISBIndex.ISBNode> set) {
        for (ISBIndex.ISBNode n : set) {
            this.Print(n.id + " ");
        }
        this.Println("");
    }

    public void PrintNodeVector(Vector<ISBIndex.ISBNode> vector) {
        for (ISBIndex.ISBNode n : vector) {
            this.Print(n.id + " ");
        }
        this.Println("");
    }

    public void PrintNodeList(List<ISBIndex.ISBNode> list) {
        for (ISBIndex.ISBNode n : list) {
            this.Print(n.id + " ");
        }
        this.Println("");
    }

    public void PrintEventQueue() {
        this.Println("event queue: ");
        for (EventItem n : this.eventQueue.setEvents) {
            this.Printf("  id=%d, exp=%d\n", n.node.id, n.timeStamp);
        }
    }

    public void PrintISB() {
        this.Print("PD: ");
        for (ISBIndex.ISBNode n : this.ISB.GetAllNodes()) {
            this.Print(n.id + " ");
        }
        this.Println("");
    }

    protected static class EventQueue {
        public TreeSet<EventItem> setEvents = new TreeSet();

        public void Insert(ISBIndex.ISBNode node, Long expTime) {
            this.setEvents.add(new EventItem(node, expTime));
        }

        public EventItem FindMin() {
            if (this.setEvents.size() > 0) {
                return this.setEvents.first();
            }
            return null;
        }

        public EventItem ExtractMin() {
            EventItem e = this.FindMin();
            if (e != null) {
                this.setEvents.remove(e);
                return e;
            }
            return null;
        }
    }

    protected static class EventItem
    implements Comparable<EventItem> {
        public ISBIndex.ISBNode node;
        public Long timeStamp;

        public EventItem(ISBIndex.ISBNode node, Long timeStamp) {
            this.node = node;
            this.timeStamp = timeStamp;
        }

        @Override
        public int compareTo(EventItem t) {
            if (this.timeStamp > t.timeStamp) {
                return 1;
            }
            if (this.timeStamp < t.timeStamp) {
                return -1;
            }
            if (this.node.id > t.node.id) {
                return 1;
            }
            if (this.node.id < t.node.id) {
                return -1;
            }
            return 0;
        }
    }
}

