/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.kmeanspm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import moa.clusterers.kmeanspm.ClusteringFeature;
import moa.clusterers.kmeanspm.ClusteringTreeNode;
import moa.clusterers.kmeanspm.CuckooHashing;
import moa.clusterers.kmeanspm.Metric;

public class ClusteringTreeHeadNode
extends ClusteringTreeNode {
    private static final long serialVersionUID = 1L;
    private final int numProjections;
    private List<double[]> projections;
    private List<CuckooHashing<List<ClusteringTreeNode>>> buckets;

    public ClusteringTreeHeadNode(double[] center, ClusteringFeature cf, int dimension, int numProjections, int hashSize, Random random) {
        super(center, cf);
        int i;
        assert (hashSize < 31);
        this.numProjections = numProjections;
        this.projections = new ArrayList<double[]>(numProjections);
        for (i = 0; i < numProjections; ++i) {
            int j;
            double[] current = new double[dimension];
            double norm = 0.0;
            for (j = 0; j < current.length; ++j) {
                double d;
                current[j] = d = random.nextGaussian();
                norm += d * d;
            }
            norm = Math.sqrt(norm);
            j = 0;
            while (j < current.length) {
                int n = j++;
                current[n] = current[n] / norm;
            }
            this.projections.add(current);
        }
        this.buckets = new ArrayList<CuckooHashing<List<ClusteringTreeNode>>>(numProjections);
        for (i = 0; i < numProjections; ++i) {
            this.buckets.add(new CuckooHashing(hashSize, random));
        }
    }

    private double project(double[] pointA, int i) {
        assert (this.projections.size() < i && this.projections.get(i).length == pointA.length);
        return Metric.dotProduct(pointA, this.projections.get(i));
    }

    private double project(double[] pointA, double[] i) {
        assert (i.length == pointA.length);
        return Metric.dotProduct(pointA, i);
    }

    private long calcBucketNumber(double val) {
        return (long)Math.floor(val / this.getThreshold());
    }

    @Override
    public ClusteringTreeNode nearestChild(double[] pointA) {
        assert (this.projections.size() > 0 && this.projections.get(0).length == pointA.length);
        int minBucketProjection = -1;
        int minSize = Integer.MAX_VALUE;
        Iterator<double[]> iIterProjections = this.projections.iterator();
        Iterator<CuckooHashing<List<ClusteringTreeNode>>> iIterBuckets = this.buckets.iterator();
        int size = this.projections.size();
        for (int i = 0; i < size; ++i) {
            int bucketSize;
            long bucketNumber = this.calcBucketNumber(this.project(pointA, iIterProjections.next()));
            List<ClusteringTreeNode> currentBucket = iIterBuckets.next().get(bucketNumber);
            if (currentBucket == null || (bucketSize = currentBucket.size()) > minSize) continue;
            minBucketProjection = i;
            minSize = bucketSize;
        }
        if (minBucketProjection == -1) {
            return null;
        }
        long bucketNumber = this.calcBucketNumber(this.project(pointA, minBucketProjection));
        double minDistance = Double.POSITIVE_INFINITY;
        ClusteringTreeNode min = null;
        List<ClusteringTreeNode> currentBucket = this.buckets.get(minBucketProjection).get(bucketNumber);
        if (currentBucket != null) {
            for (ClusteringTreeNode node : currentBucket) {
                double d = Metric.distance(pointA, node.getCenter());
                if (!(d < minDistance)) continue;
                minDistance = d;
                min = node;
            }
        }
        return min;
    }

    @Override
    public boolean addChild(ClusteringTreeNode e) {
        assert (this.projections.get(0).length == e.getClusteringFeature().getCenter().length);
        super.addChild(e);
        Iterator<double[]> iIterProjections = this.projections.iterator();
        Iterator<CuckooHashing<List<ClusteringTreeNode>>> iIterBuckets = this.buckets.iterator();
        int size = this.projections.size();
        for (int i = 0; i < size; ++i) {
            long bucketNumber = this.calcBucketNumber(this.project(e.getCenter(), iIterProjections.next()));
            CuckooHashing<List<ClusteringTreeNode>> currentBuckets = iIterBuckets.next();
            List<ClusteringTreeNode> bucket = currentBuckets.get(bucketNumber);
            if (bucket == null) {
                bucket = new ArrayList<ClusteringTreeNode>(1);
                currentBuckets.put(bucketNumber, bucket);
            }
            bucket.add(e);
        }
        return true;
    }

    @Override
    public void clearChildren() {
        super.clearChildren();
        for (CuckooHashing<List<ClusteringTreeNode>> bucket : this.buckets) {
            bucket.clear();
        }
    }
}

