/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.multilabel.errormeasurers;

import com.yahoo.labs.samoa.instances.Prediction;
import moa.classifiers.rules.multilabel.errormeasurers.AbstractMultiTargetErrorMeasurer;

public class MeanAbsoluteDeviationMT
extends AbstractMultiTargetErrorMeasurer {
    protected double weightSeen;
    protected double[] sumError;
    private static final long serialVersionUID = 1L;
    protected boolean hasStarted;
    protected int numLearnedOutputs;

    @Override
    public void addPrediction(Prediction prediction, Prediction trueClass, double weight) {
        int i;
        int numOutputs = prediction.numOutputAttributes();
        if (!this.hasStarted) {
            this.sumError = new double[numOutputs];
            this.hasStarted = true;
            for (i = 0; i < numOutputs; ++i) {
                if (!prediction.hasVotesForAttribute(i)) continue;
                ++this.numLearnedOutputs;
            }
            this.hasStarted = true;
        }
        for (i = 0; i < numOutputs; ++i) {
            if (!prediction.hasVotesForAttribute(i)) continue;
            this.sumError[i] = Math.abs(prediction.getVote(i, 0) - trueClass.getVote(i, 0)) * weight + this.fadingErrorFactor * this.sumError[i];
        }
        this.weightSeen = weight + this.fadingErrorFactor * this.weightSeen;
    }

    @Override
    public double getCurrentError() {
        if (this.weightSeen == 0.0) {
            return Double.MAX_VALUE;
        }
        double sum = 0.0;
        int numOutputs = this.sumError.length;
        for (int i = 0; i < numOutputs; ++i) {
            sum += this.sumError[i];
        }
        return sum / (this.weightSeen * (double)this.numLearnedOutputs);
    }

    @Override
    public double getCurrentError(int index) {
        return this.sumError[index] / this.weightSeen;
    }

    @Override
    public double[] getCurrentErrors() {
        double[] errors = null;
        if (this.sumError != null) {
            errors = new double[this.sumError.length];
            for (int i = 0; i < this.sumError.length; ++i) {
                errors[i] = this.sumError[i] / this.weightSeen;
            }
        }
        return errors;
    }
}

