/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.functions;

import com.yahoo.labs.samoa.instances.Instance;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.rules.functions.AMRulesRegressorFunction;
import moa.classifiers.rules.functions.Perceptron;
import moa.classifiers.rules.functions.TargetMean;
import moa.core.Measurement;

public class AdaptiveNodePredictor
extends AbstractClassifier
implements AMRulesRegressorFunction {
    private static final long serialVersionUID = 1L;
    protected Perceptron p;
    protected TargetMean tm;
    protected boolean hasStarted = false;

    @Override
    public double getCurrentError() {
        if (this.p.getCurrentError() < this.tm.getCurrentError()) {
            return this.p.getCurrentError();
        }
        return this.tm.getCurrentError();
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        double[] ret = null;
        ret = this.hasStarted ? (this.p.getCurrentError() < this.tm.getCurrentError() ? this.p.getVotesForInstance(inst) : this.tm.getVotesForInstance(inst)) : new double[]{0.0};
        return ret;
    }

    @Override
    public void resetLearningImpl() {
        this.hasStarted = false;
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        if (!this.hasStarted) {
            this.p = new Perceptron();
            this.tm = new TargetMean();
            this.p.resetLearning();
            this.tm.resetLearning();
            this.hasStarted = true;
        }
        this.p.trainOnInstance(inst);
        this.tm.trainOnInstance(inst);
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    public String getPurposeString() {
        return "Returns the prediction of a perceptron or the target mean, according to the current mean absolute error.";
    }
}

